/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.util.DBTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.search.TitleMetaDataConditionBuilder;
import org.apache.log4j.Logger;

public class PgTitleMetaDataConditionBuilder
extends TitleMetaDataConditionBuilder {
    private static final Logger logger = Logger.getLogger(PgTitleMetaDataConditionBuilder.class);

    @Override
    public String getCondition(Predicate predicate) {
        switch (predicate.getSearchComplientOperator()) {
            case MISSINGCONTENT: {
                return this.missingContent(predicate);
            }
            case NOTMISSINGCONTENT: {
                return this.notMissingContent(predicate);
            }
        }
        return this.conditionBuilderFactory.getCondition(DBTypeEnum.POSTGRESQL, predicate);
    }

    protected String buildContentCheck(String assetType) {
        String queryFormatStr = "SELECT pt.id_ from (select id ,(unnest(xpath('/metadata/asset/@path', data::xml)))::text path, (unnest(xpath('/metadata/asset/@requiresFile', data::xml)))::text  requiresFile, (unnest(xpath('/metadata/asset/@isHidden', data::xml))) isHidden from wfs.PMM_CONTENT_CLASS) xmlpcc, wfs.PMM_TITLE PT, wfs.mdm_metadata mdm WHERE xmlpcc.requiresFile='true' AND xmlpcc.isHidden IS NULL AND xmlpcc.path !='PACKAGE' AND xmlpcc.path LIKE '%s' AND PT.CONTENT_CLASS_ID= xmlpcc.ID AND mdm.document_id = PT.MDMDOCID and xmlexists(('/ECMFSpec/'||REPLACE(REPLACE(INITCAP(XMLPCC.path), 'clip', 'Clip'),'segmentgroup','SegmentGroup')||'/File/Fields/Locator/Description[Text=\"ORIGINAL\"]') passing document) is not null and xmlexists(('/ECMFSpec/' || REPLACE(REPLACE(INITCAP(XMLPCC.path), 'clip', 'Clip'),'segmentgroup','SegmentGroup')) passing document) is not null";
        String queryStr = String.format(queryFormatStr, assetType);
        logger.info((Object)("queryStr = " + queryStr));
        return queryStr;
    }
}

