/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.metadatamanager.search.ConditionBuilderFactory;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.SiteQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleMetaDataConditionBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchQueryBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchWorkFactory;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSiteJoinBuilder;
import java.util.List;

public class QueryHelperBase {
    public static final String SPACEY_ON = "\r\nON (";
    protected static final String MDM_ALIAS = "mdm";
    protected static final String PMM_TITLE = "PMM_TITLE";
    public static final String TITLE_ALIAS = "T";
    private static final String FIELD_ALIAS_BASE = "sc";
    protected static final SortingInfo DEFAULT_SORT = new SortingInfo("id", SortOrder.DESCENDING, "", FieldType.PMM_TITLE);
    protected static final String SITE_ALIAS = "dst";
    protected static final String CONTENT_CLASS_ALIAS = "cc";
    protected static final String TITLE_ID = "T.id_";
    protected static final String ORIG_TITLE_ID = "T.ORIGINALTITLE_ID";
    protected TitleSiteJoinBuilder tsjb = new TitleSiteJoinBuilder();
    protected SiteQueryBuilder ssqb = new SiteQueryBuilder();
    protected TitleMetaDataConditionBuilder tmcb = TitleSearchWorkFactory.createTitleMetaDataConditionBuilder();
    protected TitleSearchQueryBuilder tsqb = new TitleSearchQueryBuilder();
    private AssetSearchQueryBuilder assetSearchQueryBuilder;

    protected void populateResultFieldJoins(List<SearchColumn> searchColumns, StringBuilder joins, StringBuilder fieldsInner, StringBuilder fieldsOuter, StringBuilder orderBy, SortingInfo sortInfo) {
        int i;
        if (sortInfo == null) {
            sortInfo = DEFAULT_SORT;
        }
        if (sortInfo.isTitleSort() && sortInfo.getSortItemName().equals("id")) {
            orderBy.append(this.getTitleSort(sortInfo));
        }
        boolean appendedStatus = false;
        for (i = 0; i < searchColumns.size(); ++i) {
            SearchColumn sc = searchColumns.get(i);
            String fieldName = sc.getFieldName();
            String field = "";
            if (!sc.getFieldType().equals((Object)FieldType.ASSET) && fieldName.equals("id")) continue;
            if (sc.getFieldType().equals((Object)FieldType.PMM_TITLE)) {
                if (sc.getFieldName().equals("status")) {
                    if (!appendedStatus) {
                        joins.append("\r\nJOIN  PMM_TITLESTATUS TITLESTATUS ON( TITLESTATUS.ID_ = T.TITLESTATUSID) ");
                        appendedStatus = true;
                    }
                    field = "TITLESTATUS.DESCRIPTION";
                } else {
                    field = fieldName.equals("doc") ? TitleSearchWorkFactory.getDocument() : "T." + DBNameFinder.getInstance().getColumnName(Title.class, fieldName);
                }
            } else if (sc.getFieldType().equals((Object)FieldType.SITE)) {
                field = "dst." + this.ssqb.getField(fieldName);
            } else if (sc.getFieldType().equals((Object)FieldType.ASSET)) {
                field = sc.isMultiValue() || sc.getSectionType().equals("/") ? this.assetSearchQueryBuilder.getMultiValueSelect(sc.getSectionType(), sc.getFieldName()) : this.assetSearchQueryBuilder.getExtractValue(sc.getSectionType(), sc.getFieldName());
            }
            fieldsInner.append(field);
            fieldsInner.append(QueryConstants.AS);
            fieldsInner.append(FIELD_ALIAS_BASE + i);
            if (orderBy.length() == 0 && (this.isMetaDataOrderFieldMatch(sortInfo, sc) || this.isTitleOrderFieldMatch(sortInfo, sc))) {
                orderBy.append(field);
                orderBy.append(" ");
                orderBy.append(sortInfo.getOrder().getSql());
                orderBy.append(", ");
                orderBy.append(this.getTitleSort(DEFAULT_SORT));
            }
            fieldsOuter.append(FIELD_ALIAS_BASE);
            fieldsOuter.append(i);
            if (i >= searchColumns.size() - 1) continue;
            fieldsInner.append(", ");
            fieldsOuter.append(", ");
        }
        this.cleanupOrderBy(orderBy, sortInfo, i);
    }

    protected void joinOntoSite(StringBuffer query, SiteType siteType) {
        String tableName = siteType == SiteType.DISTRIBUTION_SITE ? "SITES_DISTSITETITLE" : "SITES_TRACKSITETITLE";
        query.append("\r\nLEFT JOIN ");
        query.append(tableName);
        query.append(" ");
        query.append(SITE_ALIAS);
        query.append(SPACEY_ON);
        query.append(this.tsjb.getJoin(TITLE_ALIAS, SITE_ALIAS));
        query.append(")");
    }

    protected void joinOntoMdm(StringBuffer query, boolean isSite) {
        query.append(" \r\n");
        query.append("JOIN ");
        if (isSite) {
            query.append("mdm_metadata_site ");
        } else {
            query.append("mdm_metadata ");
        }
        query.append(MDM_ALIAS);
        query.append(SPACEY_ON);
        query.append(String.format(" t.mdmdocid   = %s)", TitleSearchWorkFactory.getDocumentId()));
    }

    private void cleanupOrderBy(StringBuilder orderBy, SortingInfo sortInfo, int currentFieldIndex) {
        if (orderBy.length() == 0) {
            if (sortInfo.isTitleSort()) {
                String fieldName = sortInfo.getSortItemName();
                orderBy.append(TITLE_ALIAS);
                orderBy.append(".");
                orderBy.append(DBNameFinder.getInstance().getColumnName(Title.class, fieldName));
            } else if (sortInfo.isMetaDataSort()) {
                orderBy.append(this.assetSearchQueryBuilder.getExtractValue(sortInfo.getAssetType(), sortInfo.getSortItemName()));
            } else if (sortInfo.getFieldType().equals((Object)FieldType.SITE)) {
                orderBy.append(SITE_ALIAS);
                orderBy.append("." + this.ssqb.getField(sortInfo.getSortItemName()));
            }
            orderBy.append(" ");
            orderBy.append(sortInfo.getOrder().getSql());
            orderBy.append(", ");
            orderBy.append(this.getTitleSort(DEFAULT_SORT));
        }
        orderBy.insert(0, "ORDER BY ");
    }

    private boolean isMetaDataOrderFieldMatch(SortingInfo sortInfo, SearchColumn sc) {
        return sortInfo.isMetaDataSort() && sc.getFieldType().equals((Object)FieldType.ASSET) && sortInfo.getAssetType().equals(sc.getSectionType()) && sortInfo.getSortItemName().equals(sc.getFieldName());
    }

    private boolean isTitleOrderFieldMatch(SortingInfo sortInfo, SearchColumn sc) {
        return sortInfo.isTitleSort() && !sc.getFieldType().equals((Object)FieldType.ASSET) && sortInfo.getSortItemName().equals(sc.getFieldName());
    }

    private String getTitleSort(SortingInfo sortInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(TITLE_ALIAS);
        sb.append(".");
        sb.append(DBNameFinder.getInstance().getColumnName(Title.class, sortInfo.getSortItemName()));
        sb.append(" ");
        sb.append(sortInfo.getOrder().getSql());
        return sb.toString();
    }

    protected void appendGroupByTitleId(StringBuffer sb) {
        sb.append("\r\n");
        sb.append("GROUP BY ");
        sb.append(TITLE_ID);
    }

    protected String getRowNumWOrderBy(String orderBy) {
        return ", row_number() over (" + orderBy + ") as rnum";
    }

    protected void addCriteriaMode(CriteriaMode critMode, StringBuffer query) {
        if (critMode == null) {
            return;
        }
        query.append(" AND ");
        query.append(CONTENT_CLASS_ALIAS);
        query.append(".");
        if (critMode.equals((Object)CriteriaMode.SERIES)) {
            query.append("content_class_type_id = 1 ");
        } else {
            query.append("content_class_type_id in (0,2,3) ");
        }
    }

    protected void joinToContentClass(StringBuffer query) {
        query.append("\r\nJOIN pmm_content_class ");
        query.append(CONTENT_CLASS_ALIAS);
        query.append(" ON(");
        query.append(TITLE_ALIAS);
        query.append(".content_class_id = ");
        query.append(CONTENT_CLASS_ALIAS);
        query.append(".ID)");
    }

    protected void buildConditionRec(StringBuffer query, ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            switch (predicate.getFieldTypeLhs()) {
                case ASSET: {
                    query.append(this.tmcb.getCondition(predicate));
                    break;
                }
                case PMM_TITLE: {
                    query.append(this.tsqb.getCondition(predicate, TITLE_ALIAS));
                    break;
                }
                case SITE: {
                    query.append(this.ssqb.getCondition(predicate, SITE_ALIAS));
                }
            }
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            if (nodes.isEmpty()) {
                return;
            }
            String listOperator = list.getSqlOperator();
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildConditionRec(query, node);
            }
            query.append(")");
        }
    }

    public void setAssetSearchQueryBuilder(AssetSearchQueryBuilder assetSearchQueryBuilder) {
        this.assetSearchQueryBuilder = assetSearchQueryBuilder;
    }

    public void setConditionBuilderFactory(ConditionBuilderFactory factory) {
        this.tmcb.setConditionBuilderFactory(factory);
    }
}

