/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.FlowerConditionBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.QueryHelperBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleSearchQueryHelper
extends QueryHelperBase {
    private static final Logger logger = Logger.getLogger(TitleSearchQueryHelper.class);

    public String getQuery(TitleFilter filter, boolean includeMasters, boolean includeNonSiteCopies, boolean includeSiteCopies, Collection<Integer> siteIds, SiteType siteType, boolean includeCount, List<SearchColumn> searchColumns, List<Long> partnerIds, boolean getExtraRow) {
        StringBuilder scFieldsInner = new StringBuilder();
        StringBuilder scFieldsOuter = new StringBuilder();
        StringBuilder scJoins = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        this.populateResultFieldJoins(searchColumns, scJoins, scFieldsInner, scFieldsOuter, orderBy, filter.getSortInfo());
        StringBuffer query = new StringBuffer();
        query.append(QueryConstants.SELECT);
        query.append("T.id_");
        if (scFieldsInner.length() > 0) {
            query.append(", ");
            query.append((CharSequence)scFieldsInner);
        }
        if (includeCount) {
            query.append(", count(*) over( ) cnt ");
        }
        if (filter.hasPagingInfo()) {
            query.append(this.getRowNumWOrderBy(orderBy.toString()));
        }
        boolean joinOntoSite = !siteIds.isEmpty() || includeSiteCopies ^ includeNonSiteCopies;
        this.buildFrom(query, scJoins, joinOntoSite, filter.getCriteriaMode(), siteType);
        String specialConditions = this.getSpecialCriteria(includeMasters, includeNonSiteCopies, includeSiteCopies, siteIds, siteType);
        this.buildWhere(query, filter, specialConditions, partnerIds);
        query.append("\r\n");
        if (!filter.hasPagingInfo()) {
            query.append((CharSequence)orderBy);
        }
        if (filter.hasPagingInfo()) {
            this.wrapWithPagingClause(query, filter.getPageInfo(), includeCount, scFieldsOuter, getExtraRow);
        }
        String result = query.toString();
        logger.debug((Object)result);
        return result;
    }

    public String getQuery(ExpNode criteria, SearchColumn searchColumn) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT value_ FROM ( SELECT ");
        query.append(this.buildXmlQuery(searchColumn, criteria));
        this.buildFrom(query, new StringBuilder(), false, null, null);
        String specialConditions = this.getSpecialCriteria(true, false, false, new ArrayList<Integer>(), null);
        this.buildWhere(query, new TitleFilter(), specialConditions, new ArrayList<Long>());
        query.append("\r\n) rv,  xmltable('for $i in /Result return $i' passing rv.assetinfo columns value_ varchar2(2000) path 'Value') xtab");
        String result = query.toString();
        logger.debug((Object)result);
        return result;
    }

    private String buildXmlQuery(SearchColumn searchColumn, ExpNode criteria) {
        StringBuffer query = new StringBuffer();
        String assetType = searchColumn.getSectionType();
        String field = searchColumn.getFieldName();
        if (!assetType.equals("/") && !assetType.equals("//*")) {
            new SearchSchemaHelper().getCorrectedAssetPath(assetType, false);
        }
        query.append("xmlquery('for $field in ");
        query.append(assetType);
        if (!field.startsWith("/")) {
            query.append("/*");
        }
        query.append(field);
        query.append(" where ");
        this.buildXmlCondition(query, criteria, searchColumn);
        query.append(" return <Result><Value>{$field}</Value></Result>' passing sys_nc_rowinfo$ RETURNING CONTENT) AS assetInfo");
        return query.toString();
    }

    private void buildXmlCondition(StringBuffer query, ExpNode criteria, SearchColumn searchColumn) {
        if (criteria instanceof ExpValue) {
            query.append(FlowerConditionBuilder.getCondition(((ExpValue)criteria).getPredicate()));
        } else if (criteria instanceof ExpList) {
            ExpList list = (ExpList)criteria;
            String op = list.getSqlOperator();
            if (list.isEmpty()) {
                return;
            }
            query.append("(");
            Iterator iterator = list.getNodes().iterator();
            while (iterator.hasNext()) {
                this.buildXmlCondition(query, (ExpNode)iterator.next(), searchColumn);
                if (!iterator.hasNext()) continue;
                query.append(op);
            }
            query.append(")");
        }
    }

    private void buildFrom(StringBuffer query, StringBuilder scJoins, boolean joinOntoSite, CriteriaMode critMode, SiteType siteType) {
        query.append(" \r\nFROM PMM_TITLE T");
        this.joinOntoMdm(query, joinOntoSite);
        query.append((CharSequence)scJoins);
        if (critMode != null) {
            this.joinToContentClass(query);
        }
        if (joinOntoSite) {
            this.joinOntoSite(query, siteType);
        }
    }

    private void buildWhere(StringBuffer query, TitleFilter filter, String specialConditions, List<Long> partnerIds) {
        query.append("\r\nWHERE ");
        query.append("titlestatusid <> 5 ");
        this.addCriteriaMode(filter.getCriteriaMode(), query);
        if (filter.hasCriteria()) {
            query.append(" AND ");
            this.buildConditionRec(query, filter.getRootNode());
        }
        if (!partnerIds.isEmpty()) {
            query.append(" AND ");
            query.append("T.Partner_Id in (");
            Iterator<Long> iterator = partnerIds.iterator();
            while (iterator.hasNext()) {
                query.append(iterator.next());
                if (!iterator.hasNext()) continue;
                query.append(", ");
            }
            query.append(")");
        }
        if (!specialConditions.isEmpty()) {
            query.append(" AND ");
            query.append("(");
            query.append(specialConditions);
            query.append(")");
        }
    }

    private String getSpecialCriteria(boolean includeMasters, boolean includeNonSiteCopies, boolean includeSiteCopies, Collection<Integer> siteIds, SiteType siteType) {
        StringBuffer result = new StringBuffer();
        if (includeMasters && includeNonSiteCopies && includeSiteCopies && siteIds.isEmpty()) {
            return "";
        }
        String origIdIsNotNull = this.tsqb.getCondition(new Predicate("originalId", "", FieldType.PMM_TITLE, LogicalOperator.ISNOTEMPTY, Boolean.valueOf(false)), "T");
        String origIdIsNull = this.tsqb.getCondition(new Predicate("originalId", "", FieldType.PMM_TITLE, LogicalOperator.ISEMPTY, Boolean.valueOf(false)), "T");
        String hasSite = this.ssqb.getCondition(new Predicate("id", "", FieldType.SITE, LogicalOperator.ISNOTEMPTY, Boolean.valueOf(false)), "dst");
        String noSite = this.ssqb.getCondition(new Predicate("id", "", FieldType.SITE, LogicalOperator.ISEMPTY, Boolean.valueOf(false)), "dst");
        if (includeMasters && includeNonSiteCopies && includeSiteCopies) {
            result.append(noSite);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
        } else if (includeMasters && includeNonSiteCopies) {
            result.append(noSite);
        } else if (includeNonSiteCopies && includeSiteCopies && siteIds.isEmpty()) {
            result.append(origIdIsNotNull);
        } else if (includeNonSiteCopies && includeSiteCopies && !siteIds.isEmpty()) {
            result.append(origIdIsNotNull);
            result.append(" AND (");
            result.append(noSite);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
            result.append(")");
        } else if (includeMasters && includeSiteCopies && siteIds.isEmpty()) {
            result.append(origIdIsNull);
            result.append(" OR ");
            result.append(hasSite);
        } else if (includeMasters && includeSiteCopies && !siteIds.isEmpty()) {
            result.append(origIdIsNull);
            result.append(" OR ");
            result.append(this.getSiteIn(siteIds, siteType));
        } else {
            if (includeMasters) {
                return origIdIsNull;
            }
            if (includeNonSiteCopies) {
                result.append(origIdIsNotNull);
                result.append(" AND ");
                result.append(noSite);
            } else {
                if (includeSiteCopies && siteIds.isEmpty()) {
                    return hasSite;
                }
                if (includeSiteCopies && !siteIds.isEmpty()) {
                    return this.getSiteIn(siteIds, siteType);
                }
            }
        }
        return result.toString();
    }

    private String getSiteIn(Collection<Integer> sitesCopiesToInclude, SiteType siteType) {
        ArrayList<String> values = new ArrayList<String>();
        for (Integer id : sitesCopiesToInclude) {
            values.add(String.valueOf(id));
        }
        return this.ssqb.getCondition((Predicate)new PredicateRightValue("distributionSite", "", FieldType.SITE, values, LogicalOperator.IN, "integer", Boolean.valueOf(false)), "dst");
    }

    private void wrapWithPagingClause(StringBuffer sb, PagingInfo info, boolean includeCnt, StringBuilder scFieldsOuter, boolean getExtraRow) {
        int startIndex = info.getStartIndex() + 1;
        int endIndex = info.getStartIndex() + info.getMaxRecordCount();
        if (getExtraRow) {
            ++endIndex;
        }
        StringBuffer fields = new StringBuffer(DBNameFinder.getInstance().getColumnName(Title.class, "id"));
        if (scFieldsOuter.length() > 0) {
            fields.append(", ");
            fields.append(scFieldsOuter.toString());
        }
        if (includeCnt) {
            fields.append(", cnt");
        }
        StringBuilder insert = new StringBuilder(QueryConstants.SELECT);
        insert.append(fields);
        insert.append("\r\nFROM (");
        sb.insert(0, insert);
        sb.append(") WHERE RNUM BETWEEN ");
        sb.append(startIndex);
        sb.append(" and ");
        sb.append(endIndex);
    }
}

