/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.thumbnail;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.PartnerThumbnail;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleThumbnailReader;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class TitleThumbnailReader
implements ITitleThumbnailReader {
    private static final Logger logger = Logger.getLogger(TitleThumbnailReader.class);
    private final String THUMBNAIL_LARGE_SUFFIX = "large";
    private final String THUMBNAIL_MEDIUM_SUFFIX = "medium";

    @Transactional
    public InputStream getThumbnail(long titleId) {
        InputStream stream = null;
        try {
            IAssetTypesConfigurationService service = this.getService(IAssetTypesConfigurationService.class);
            List assetTypes = service.getThumbnailAssetTypes();
            Session session = HibernateContext.getContext().getCurrentSession();
            String queryString = "SELECT property.assetId, property.assetType, property.value FROM TitleAssetProperty property WHERE property.name = 'THUMBNAIL' AND property.titleId = :titleID ORDER BY property.updateDate DESC";
            Query query = session.createQuery(queryString);
            query.setParameter("titleID", (Object)titleId);
            List results = query.list();
            ArrayList<AssetThumbnail> thumbnails = new ArrayList<AssetThumbnail>();
            for (Object result : results) {
                Object[] values = (Object[])result;
                Long assetId = (Long)values[0];
                String assetType = (String)values[1];
                String value = (String)values[2];
                if (!assetTypes.contains(assetType) || value.toLowerCase().contains("large") || value.toLowerCase().contains("medium")) continue;
                thumbnails.add(new AssetThumbnail(assetId, assetType, value));
            }
            Collections.sort(thumbnails, new AssetThumbnailComparator(assetTypes));
            for (AssetThumbnail thumbnail : thumbnails) {
                try {
                    stream = new FileInputStream(new File(thumbnail.thumbnailPath));
                    break;
                }
                catch (Exception e) {
                    String msg = "Failed to read thumbnail: " + thumbnail.thumbnailPath + ", error: " + e.getLocalizedMessage();
                    logger.warn((Object)msg);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to get thumbnail for title[#" + titleId + "], using default. Error: " + e.getLocalizedMessage()));
        }
        if (stream == null) {
            stream = this.getPartnerThumbnail(titleId);
        }
        return stream;
    }

    @Transactional
    public InputStream getThumbnail(long titleId, long assetId) {
        ITitleAssetResourceManager resourceManager = this.getService(ITitleAssetResourceManager.class);
        TitleAssetResource resource = resourceManager.getThumbnail(titleId, assetId);
        if (resource != null) {
            try {
                return new FileInputStream(new File(resource.getResourcePath()));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read thumbnail: " + resource.getResourcePath() + ", error: " + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    private InputStream getPartnerThumbnail(long titleId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String queryString = "SELECT thumbnail FROM PartnerThumbnail thumbnail, Title title WHERE thumbnail.partnerId = title.partnerId and title.id = :titleID";
            Query query = session.createQuery(queryString);
            query.setParameter("titleID", (Object)titleId);
            PartnerThumbnail partnerThumbnail = (PartnerThumbnail)query.uniqueResult();
            if (partnerThumbnail != null && partnerThumbnail.getThumbnailImage() != null) {
                return new ByteArrayInputStream(partnerThumbnail.getThumbnailImage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to read partner thumbnail for title[#" + titleId + "], error: " + e.getLocalizedMessage()));
        }
        return null;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    public void start() {
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    private static final class AssetThumbnailComparator
    implements Comparator<AssetThumbnail> {
        List<String> assetTypes;

        public AssetThumbnailComparator(List<String> assetTypes) {
            this.assetTypes = assetTypes;
        }

        @Override
        public int compare(AssetThumbnail o1, AssetThumbnail o2) {
            int typeIndex2;
            int typeIndex1 = this.assetTypes.indexOf(o1.assetType);
            if (typeIndex1 != (typeIndex2 = this.assetTypes.indexOf(o2.assetType))) {
                Integer index1 = typeIndex1 < 0 ? Integer.MAX_VALUE : new Integer(typeIndex1);
                Integer index2 = typeIndex2 < 0 ? Integer.MAX_VALUE : new Integer(typeIndex2);
                return index1.compareTo(index2);
            }
            Long assetId1 = o1.assetId;
            Long assetId2 = o2.assetId;
            return assetId1.compareTo(assetId2);
        }
    }

    private static final class AssetThumbnail {
        long assetId;
        String assetType;
        String thumbnailPath;

        public AssetThumbnail(long assetId, String assetType, String thumbnailPath) {
            this.assetId = assetId;
            this.assetType = assetType;
            this.thumbnailPath = thumbnailPath;
        }
    }
}

