/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class IngestCountHelper {
    private static final Logger logger = Logger.getLogger(IngestCountHelper.class);
    private static final TitleStatus[] TITLE_STATUS = new TitleStatus[]{TitleStatus.PLANNED};

    private IngestCountHelper() {
    }

    public static IngestCountHelper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Transactional
    public long getTotalIngestCount(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return 0L;
        }
        Long count = null;
        try {
            count = (Long)HibernateContext.getContext().getCurrentSession().createCriteria(Title.class).setProjection(Projections.rowCount()).add(Restrictions.isNull((String)"originalId")).add(Restrictions.not((Criterion)Restrictions.in((String)"status", (Object[])TITLE_STATUS))).add(Restrictions.in((String)"contentClassId", this.getContentClassId())).add(Restrictions.between((String)"createDate", (Object)startDate, (Object)endDate)).uniqueResult();
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception occurs in IngestCountHelper#getTotalIngestedCount", (Throwable)e);
        }
        if (null == count) {
            return 0L;
        }
        return count;
    }

    private Set<Long> getContentClassId() {
        List contentClassList = null;
        IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        try {
            contentClassList = contentClassService.getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e2) {
            logger.error((Object)"Exception occurs when getting all content classes without metadata.", (Throwable)e2);
        }
        if (null == contentClassList || contentClassList.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> set = new HashSet<Long>();
        contentClassList.forEach(e -> {
            if (null == e || this.isContentClassTypeFiltered(e.getType())) {
                return;
            }
            set.add(e.getId());
        });
        return set;
    }

    private boolean isContentClassTypeFiltered(ContentClass.Type contentClassType) {
        for (ContentClass.Type type : LicenseFilter.CONTENT_CLASS_FILTER) {
            if (type != contentClassType) continue;
            return true;
        }
        return false;
    }

    private static class SingletonHelper {
        private static final IngestCountHelper INSTANCE = new IngestCountHelper();

        private SingletonHelper() {
        }
    }
}

