/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ContainerCache
extends CacheService<IContainer> {
    private static String SERVICE_NAME = "Container Cache";
    private static int THREAD_FACTORY_THREAD_COUNT = 1;
    public static int MAX_CONTAINER_COUNT = 5000;
    private Logger logger = Logger.getLogger(ContainerCache.class);
    private static ICacheService<IContainer> instance;
    private ScheduledThreadPoolExecutor executor;
    private Map<Serializable, IContainer> containerMap = new ConcurrentHashMap<Serializable, IContainer>();

    protected ContainerCache() {
        super(SERVICE_NAME, MAX_CONTAINER_COUNT);
    }

    public static synchronized ICacheService<IContainer> getInstance() {
        if (instance == null) {
            instance = new ContainerCache();
        }
        return instance;
    }

    public void start() {
        super.start();
        this.logger.debug((Object)"Starting Container Cache service.");
        this.logger.debug((Object)"Loading partners and services in the background now.");
        this.executor = new ScheduledThreadPoolExecutor(THREAD_FACTORY_THREAD_COUNT);
        this.populatePartners();
        this.logger.debug((Object)"Done starting the cache.");
    }

    public void stop() {
        this.executor.shutdown();
    }

    private List<Partner> populatePartners() {
        Callable<List<Partner>> starterThread = new Callable<List<Partner>>(){

            @Override
            public List<Partner> call() throws Exception {
                IPartnerManagement partnerMgr = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
                List partners = partnerMgr.getAllActivePartners();
                ContainerCache.this.logger.info((Object)("Got " + partners.size() + " partners from db."));
                for (Partner p : partners) {
                    ContainerCache.this.add((Serializable)Long.valueOf(p.getContainerContextId()), (IContainer)p);
                }
                return partners;
            }
        };
        this.executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        return null;
    }

    public void add(Serializable key, IContainer entity) {
        this.containerMap.put(key, entity);
    }

    public int count() {
        return this.containerMap.size();
    }

    public IContainer get(Serializable key) {
        return this.containerMap.get(key);
    }

    public Collection<Serializable> getKeys() {
        return this.containerMap.keySet();
    }

    public void remove(Serializable key) {
        this.containerMap.remove(key);
    }
}

