/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IXPathPairParameter;
import com.tandbergtv.workflow.adaptor.handler.XPathPairParameterImpl;
import com.tandbergtv.workflow.adaptor.handler.XPathRepeatParameter;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPairLoader {
    private static final String XPAIR_REPEAT_TAG_NAME = "/xPathConfiguration/RepeatMapping";
    private static final String XPAIR_SOURCE_TAG_NAME = "SourceXPath";
    private static final String XPAIR_DESTINATION_TAG_NAME = "DestinationXPath";
    private IHandlerConfiguration configuration;
    private static final ThreadLocal<XPath> TRANSFORMER = new ThreadLocal<XPath>(){

        @Override
        protected XPath initialValue() {
            return XPathFactory.newInstance().newXPath();
        }
    };

    public XPathPairLoader(IHandlerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public XPathRepeatParameter loadXPathRepeatParameter(String fileName) throws HandlerException {
        XPathRepeatParameter repeat = null;
        try {
            ClassLoader loader = this.configuration.getClassLoader();
            String configPath = this.configuration.getDefaultConfigPath();
            Document document = XMLDocumentUtility.loadFile((ClassLoader)loader, (String)(configPath + fileName));
            XPath xPath = TRANSFORMER.get();
            xPath.reset();
            Node node = (Node)xPath.evaluate(XPAIR_REPEAT_TAG_NAME, document, XPathConstants.NODE);
            if (node == null) {
                return null;
            }
            Node source = (Node)xPath.evaluate(XPAIR_SOURCE_TAG_NAME, node, XPathConstants.NODE);
            Node destination = (Node)xPath.evaluate(XPAIR_DESTINATION_TAG_NAME, node, XPathConstants.NODE);
            repeat = new XPathRepeatParameter(source.getTextContent(), destination.getTextContent());
            NodeList paths = (NodeList)xPath.evaluate("Mapping", node, XPathConstants.NODESET);
            for (int i = 0; i < paths.getLength(); ++i) {
                IXPathPairParameter pair = this.addNodeContentsToList(paths.item(i));
                repeat.addXPathPairParameter(pair);
            }
        }
        catch (Exception e) {
            throw new HandlerException("Failed to load document " + fileName, e);
        }
        return repeat;
    }

    public List<IXPathPairParameter> loadXPathPairs(String fileName) throws HandlerException {
        ArrayList<IXPathPairParameter> pairs = new ArrayList();
        try {
            ClassLoader loader = this.configuration.getClassLoader();
            String configPath = this.configuration.getDefaultConfigPath();
            Document doc = XMLDocumentUtility.loadFile((ClassLoader)loader, (String)(configPath + fileName));
            NodeList nodeSet = doc.getElementsByTagName("Mapping");
            pairs = this.addNodeContentsToList(nodeSet);
        }
        catch (IOException ex) {
            throw new HandlerException("Could not read from mapping file.", ex);
        }
        catch (Exception ex) {
            throw new HandlerException("Could not parse DOM document.", ex);
        }
        return pairs;
    }

    private List<IXPathPairParameter> addNodeContentsToList(NodeList nodeSet) throws HandlerException {
        ArrayList<IXPathPairParameter> pairs = new ArrayList<IXPathPairParameter>();
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            IXPathPairParameter pair = this.addNodeContentsToList(nodeSet.item(i));
            pairs.add(pair);
        }
        return pairs;
    }

    private IXPathPairParameter addNodeContentsToList(Node currentNode) throws HandlerException {
        NodeList children = currentNode.getChildNodes();
        String sourcePath = null;
        String destPath = null;
        for (int j = 0; j < children.getLength(); ++j) {
            if (children.item(j).getNodeName().equals(XPAIR_SOURCE_TAG_NAME)) {
                sourcePath = children.item(j).getTextContent();
                continue;
            }
            if (!children.item(j).getNodeName().equals(XPAIR_DESTINATION_TAG_NAME)) continue;
            destPath = children.item(j).getTextContent();
        }
        if (sourcePath == null || destPath == null) {
            throw new HandlerException("XPath Mapping file is invalid.");
        }
        return new XPathPairParameterImpl(sourcePath, destPath);
    }
}

