/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.ericsson.cms.neptune.rabbitmq.factory.MQServiceFactory;
import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.ericsson.neptune.es.CmsTransportClient;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import com.tandbergtv.workflow.core.service.internal.DistributedQueueService;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.ILogWriter;
import com.tandbergtv.workflow.driver.NodeLogListener;
import com.tandbergtv.workflow.driver.boot.EngineDriverProperties;
import com.tandbergtv.workflow.driver.command.buffer.DelayedCommandService;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.internal.ConvertorFactory;
import com.tandbergtv.workflow.driver.internal.DefaultProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.internal.IdGeneratorFactory;
import com.tandbergtv.workflow.driver.internal.LogElasticsearchWriterService;
import com.tandbergtv.workflow.driver.internal.MessageQueueService;
import com.tandbergtv.workflow.driver.internal.PersistenceServiceFactory;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.TaskCompletionService;
import com.tandbergtv.workflow.driver.internal.WorkOrderLoader;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessConvertor;
import com.tandbergtv.workflow.driver.internal.callable.ReadClusterProperties;
import com.tandbergtv.workflow.driver.internal.monitor.ExecutionTimeMonitor;
import com.tandbergtv.workflow.driver.internal.monitor.GenericAlarmNotificationProvider;
import com.tandbergtv.workflow.driver.internal.monitor.ScheduledMetricLogWriter;
import com.tandbergtv.workflow.driver.message.queue.FileMessageConsumerFactory;
import com.tandbergtv.workflow.driver.message.queue.IFileMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.MessageQueueFactory;
import com.tandbergtv.workflow.driver.message.queue.WorkOrderMessageConsumer;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapperFactory;
import com.tandbergtv.workflow.driver.search.TokenSearchService;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchService;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.service.ITaskCompletionService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateCache;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import com.tandbergtv.workflow.driver.template.coder.TemplateCoderFactory;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TimerManager;
import com.tandbergtv.workflow.exe.email.EmailServiceSettingUpdateListener;
import com.tandbergtv.workflow.exe.email.IEmailService;
import com.tandbergtv.workflow.exe.email.SimpleEmailService;
import com.tandbergtv.workflow.log.LogConverterService;
import com.tandbergtv.workflow.log.LogSyncService;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.message.producer.MessageProducer;
import com.tandbergtv.workflow.message.producer.MessageProducerFactory;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiter;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiterFactory;
import com.tandbergtv.workflow.process.ratelimiter.RateLimiterFactory;
import com.tandbergtv.workflow.settings.DateFormatUpdateListener;
import com.tandbergtv.workflow.settings.LicenseSettingUpdateListener;
import com.tandbergtv.workflow.settings.RateLimiterSettingUpdateListener;
import com.tandbergtv.workflow.settings.RemoteSettingsUpdateNotificationService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.LicenseProviderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Activator {
    private static final String PROCESS_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Cumulative";
    private static final String PROCESS_MONITOR_CURRENT_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Current";
    private static final String PROCESS_MONITOR_TOKENS_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=CurrentBranched";
    private static final Logger LOGGER = Logger.getLogger(Activator.class);
    private IClusterService clusterService;
    private CmsTransportClient esClient;

    public void start() {
        this.initializeJbpmTypes();
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        Configuration configuration = Configuration.build((ResourceBundle)bundle);
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().register((IColleague)driver);
        IEventHandlerRegistry handlers = this.getService(IEventHandlerRegistry.class);
        handlers.registerEventHandler(new NodeLogListener());
        handlers.registerEventHandler((IColleague)new ExecutionTimeMonitor());
        TemplateCache templateCache = TemplateCache.createTemplateCache();
        this.addService((Service)templateCache);
        this.addService((Service)new DistributedCache("Delete Template Cache"));
        SessionFactory factory = HibernateUtil.getSessionFactory();
        IdGeneratorFactory.setSessionFactory((SessionFactory)factory);
        this.addService((Service)IdGeneratorFactory.createCustomTokenIdGenerator());
        WorkflowProcessCacheWrapperFactory.activateDefaultCoder((WorkflowProcessConvertor)ConvertorFactory.createProcessConvertor((SessionFactory)factory));
        String cacheName = bundle.getString("driver.cache.name");
        int size = configuration.getInteger("driver.cache.size", 50);
        WorkflowProcessCache workflowProcessCache = new WorkflowProcessCache(cacheName, size);
        this.addService((Service)workflowProcessCache);
        ProcessPersistenceService processPersistenceService = PersistenceServiceFactory.createPersistenceService((SessionFactory)factory);
        WorkOrderLoader workOrderLoader = new WorkOrderLoader(processPersistenceService);
        this.addService((Service)workOrderLoader);
        this.addService((Service)new WFSElasticSearchService(factory, (IWorkOrderLoader)workOrderLoader));
        this.addService(new TemplateCoderFactory());
        ITemplateService templateService = PersistenceServiceFactory.createTemplateService((SessionFactory)factory, (TemplateCache)templateCache);
        this.addService((Service)templateService);
        TemplateLoaderService templateLoaderService = new TemplateLoaderService(10000, templateService);
        this.addService((Service)templateLoaderService);
        this.addService((Service)new TokenSearchService(factory));
        this.addService((Service)processPersistenceService);
        this.addService(new SimpleEmailService());
        this.addService((Service)new RecoverableDistributedScheduler("distributed-scheduler", 4));
        this.addService((Service)new DistributedScheduler("one-shot-distributed-scheduler", 8));
        this.addService((Service)new TaskCompletionService());
        this.addService((Service)new TimerManager());
        this.addService(new DelayedCommandService());
        this.addService((Service)new DistributedQueueService("distributed-queue"));
        this.addService((Service)new MessageQueueService());
        this.addService((Service)new DefaultProgressTrackingStrategy());
        Properties props = this.getProperties();
        this.addGlobalScheduleService(configuration, props);
        this.startProcessManager(templateLoaderService, props);
        this.startRateLimiterFactoryService();
        this.addMessageQueueService(templateLoaderService, factory);
        this.addRecoveryJob(templateLoaderService);
        this.addService(FileMessageConsumerFactory.create());
        this.getService(IAlarmNotificationService.class).addProvider((IAlarmNotificationProvider)new GenericAlarmNotificationProvider());
        try {
            this.setupHistoryLogging(props, factory);
        }
        catch (UnknownHostException e) {
            LOGGER.fatal((Object)"Could not set up History Logging.", (Throwable)e);
        }
        this.addService((Service)ScheduledMetricLogWriter.getInstance());
        this.addNeptuneSettingUpdateNotificationService();
    }

    private void addGlobalScheduleService(Configuration configuration, Properties props) {
        int core = configuration.getInteger("messages.pool.size", 50);
        int max = configuration.getInteger("messages.pool.max", 100);
        core = Configuration.build((Properties)props).getInteger("pool.size", core);
        max = core > max ? core : max;
        this.addService((Service)new Scheduler("message-thread", core, max));
    }

    private void addNeptuneSettingUpdateNotificationService() {
        RemoteSettingsUpdateNotificationService service = new RemoteSettingsUpdateNotificationService();
        service.addUpdateListener(new DateFormatUpdateListener());
        service.addUpdateListener(new LicenseSettingUpdateListener());
        service.addUpdateListener(new RateLimiterSettingUpdateListener());
        service.addUpdateListener(new EmailServiceSettingUpdateListener());
        this.addService(service);
    }

    private IProcessManagerService startProcessManager(TemplateLoaderService templateService, Properties props) {
        ProcessManager processManagerService = new ProcessManager(props);
        this.registerMBeans((IProcessManagerService)processManagerService);
        ServiceRegistry.getDefault().register(processManagerService.getServiceName(), (Service)processManagerService);
        processManagerService.start();
        return processManagerService;
    }

    private MessageProducer addMessageQueueService(TemplateLoaderService templateLoaderService, SessionFactory factory) {
        RabbitMQService rabbitMQService = MQServiceFactory.createRabbitMQService();
        MessageProducer messageProducer = MessageProducerFactory.createMessageProducer((IRabbitMQService)rabbitMQService);
        this.addService((Service)messageProducer);
        CommandExecutor cmdExecutor = new CommandExecutor();
        this.addService(cmdExecutor);
        templateLoaderService.addPostTaskAfterCachLoaded("IMessageQueueConsumer", (Callable)new Callable<Void>((IRabbitMQService)rabbitMQService, cmdExecutor, factory){
            final /* synthetic */ IRabbitMQService val$rabbitMQService;
            final /* synthetic */ CommandExecutor val$cmdExecutor;
            final /* synthetic */ SessionFactory val$factory;
            {
                this.val$rabbitMQService = iRabbitMQService;
                this.val$cmdExecutor = commandExecutor;
                this.val$factory = sessionFactory;
            }

            @Override
            public Void call() throws Exception {
                Activator.this.addService(MessageQueueFactory.createMessageConsumer(this.val$rabbitMQService, this.val$cmdExecutor, this.val$factory));
                return null;
            }
        });
        return messageProducer;
    }

    private void addRecoveryJob(TemplateLoaderService templateLoaderService) {
        if (this.getClusterService().isMaster()) {
            templateLoaderService.addPostTaskAfterCachLoaded("Process Recovery Job", ServiceLookup.findProcessManagerService().getRecoveryJob());
        }
    }

    public void stop() {
        this.removeService(LogConverterService.class);
        this.removeService(ILogWriter.class);
        this.removeService(LogSyncService.class);
        this.removeService(WorkflowLogService.class);
        this.removeService(WorkOrderMessageConsumer.class);
        this.removeService(CommandExecutor.class);
        this.removeService(MessageProducer.class);
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"ProcessMonitor MBean unregistration failed");
        }
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().unregister((IColleague)driver);
        this.stopRateLimiterFactoryService();
        this.removeService(IProcessManagerService.class);
        this.removeService(IFileMessageConsumer.class);
        this.removeService(IProgressTrackingStrategy.class);
        this.removeService(ITimerService.class);
        this.removeService(IMessageQueueService.class);
        this.removeService(IDistributedQueueService.class);
        this.removeService(IDelayedCommandService.class);
        this.removeService("message-thread");
        this.removeService(ITaskCompletionService.class);
        this.removeService("one-shot-distributed-scheduler");
        this.removeService("distributed-scheduler");
        this.removeService(RemoteSettingsUpdateNotificationService.class);
        this.removeService(IEmailService.class);
        this.removeService(ITemplateLoaderService.class);
        this.removeService(IWorkOrderLoader.class);
        this.removeService(IPersistenceService.class);
        this.removeService(ITokenSearchService.class);
        this.removeService(IProcessSearchService.class);
        this.removeService(bundle.getString("driver.cache.name"));
        this.removeService("Delete Template Cache");
        this.removeService("JpdlXml Parser Service");
        this.removeService("ByteArray Parser Service");
        this.removeService(ITemplateService.class);
        this.removeService(TemplateCache.getDefaultServiceName());
        this.removeService(ScheduledMetricLogWriter.class);
        if (this.esClient != null) {
            this.esClient.close();
        }
        LOGGER.info((Object)"Process execution runtime destroyed");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void setupHistoryLogging(final Properties props, SessionFactory factory) throws UnknownHostException {
        String dir = this.getHistoryDirectory();
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        Configuration config = Configuration.build((Properties)props);
        Long archivingPeriod = config.getLong("history.archiving.period", TimeUnit.HOURS.toSeconds(6L));
        Long retentionWindow = config.getLong("history.retention.period", TimeUnit.DAYS.toSeconds(30L));
        String esPropsFileName = WFSElasticSearchService.getESPropertiesFileName();
        this.esClient = new CmsTransportClient(esPropsFileName);
        this.addService(new WorkflowLogService(factory, dir, archivingPeriod, retentionWindow, 1, this.esClient.getTransportClient()));
        this.setupHistorySync(props, this.esClient.getTransportClient());
        IClusterService currentClusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        currentClusterService.getInstance().getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent e) {
            }

            public void memberRemoved(MembershipEvent e) {
                Activator.this.setupHistorySync(props, Activator.this.esClient.getTransportClient());
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        this.addService((Service)new LogElasticsearchWriterService(esPropsFileName));
        this.addService(new LogConverterService());
    }

    private void setupHistorySync(Properties neptuneProps, TransportClient client) {
        if (!this.getClusterService().isMaster()) {
            return;
        }
        if (this.getService(LogSyncService.class) != null) {
            return;
        }
        ((WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class)).startGCOnMaster();
        Long syncPeriod = Configuration.build((Properties)neptuneProps).getLong("history.sync.period", TimeUnit.HOURS.toSeconds(1L));
        this.addService(new LogSyncService(HibernateUtil.getSessionFactory(), syncPeriod, client));
    }

    private void registerMBeans(IProcessManagerService service) {
        IStatistics statistics = service.getStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics.getCumulativeStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getProcessStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getTokenStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
            IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup("log-recorder");
            recorder.addObserver(Observers.localJMXObserver((String)"com.tandbergtv.watchpoint:type=ExecutionTime,*", (String)"EWMA"));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Registration of MBean failed, monitoring will not be available", (Throwable)e);
        }
    }

    private void initializeJbpmTypes() {
        String resource = JbpmConfiguration.Configs.getString((String)"resource.varmapping");
        InputStream is = ClassLoaderUtil.getStream((String)resource);
        Element rootElement = XmlUtil.parseXmlInputStream((InputStream)is).getDocumentElement();
        ObjectInfo oi = new ObjectFactoryParser().parse(XmlUtil.element((Element)rootElement, (String)"list"));
        ObjectFactoryImpl of = (ObjectFactoryImpl)JbpmConfiguration.Configs.getObjectFactory();
        of.addObjectInfo(oi);
        IOUtils.closeQuietly((InputStream)is);
    }

    private String getHistoryDirectory() {
        try {
            return ApplicationProperties.getInstance().getProperty("install.dir") + "/history/process/";
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties getProperties() {
        EngineDriverProperties props = new EngineDriverProperties();
        String alarmsIntervalProperty = this.loadAlarmsInterval();
        props.setProperty("time_interval", alarmsIntervalProperty);
        int limit = this.loadLicenseMaxCreateRate();
        props.setProperty("create.limit", String.valueOf(limit));
        if (this.getClusterService().isMaster()) {
            return props;
        }
        IDistributedSchedulerService scheduler = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        Future future = scheduler.schedule((Callable)new ReadClusterProperties());
        Properties properties = new Properties();
        try {
            properties = (Properties)future.get(30L, TimeUnit.SECONDS);
            for (Object name : properties.keySet()) {
                props.put(name, properties.get(name));
                LOGGER.debug((Object)(name + "=" + properties.get(name)));
            }
            props.store();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to get properties from master", (Throwable)e);
        }
        return props;
    }

    private int loadLicenseMaxCreateRate() {
        int limit = Integer.MAX_VALUE;
        try {
            limit = Integer.parseInt(LicenseProviderFactory.getLicenseProvider().getProperty("ingest.thruput"));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to read license", (Throwable)e);
        }
        return limit;
    }

    private String loadAlarmsInterval() {
        String alarmsIntervalProperty = null;
        ISettingsProvider settingsProvider = new SettingsPluginLoader().createSettingsProvider();
        if (settingsProvider != null) {
            alarmsIntervalProperty = settingsProvider.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("time_interval");
        }
        if (alarmsIntervalProperty == null) {
            alarmsIntervalProperty = "2";
        }
        return alarmsIntervalProperty;
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = this.getService(IClusterService.class);
        }
        return this.clusterService;
    }

    private void startRateLimiterFactoryService() {
        IRateLimiterFactory rateLimiterFactory = RateLimiterFactory.getInstance();
        IRateLimiter rateLimiter = rateLimiterFactory.create();
        ISettingsProvider settingsProvider = new SettingsPluginLoader().createSettingsProvider();
        if (settingsProvider != null) {
            Map<String, String> settings = settingsProvider.getProperties("com.tandbergtv.workflow.application");
            RateLimiterSettingUpdateListener.update(rateLimiter, settings);
        }
        this.addService((Service)rateLimiterFactory);
    }

    private void stopRateLimiterFactoryService() {
        this.removeService(RateLimiterFactory.class);
    }
}

