/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.internal.CreateIdExistedException;
import com.tandbergtv.workflow.driver.message.selector.TemplateSelectorFactory;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import com.tandbergtv.workflow.messageprocessor.templateselector.IPrioritySelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.ITemplateSelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.SelectorOutput;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectionException;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ClientExtensionClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class CreateCommand
extends AbstractCommand {
    private static final long serialVersionUID = -6221292298045535365L;
    private static final Logger LOGGER = Logger.getLogger(CreateCommand.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    public CreateCommand(WorkflowMessage message) {
        super(message);
    }

    public WorkflowMessage execute() {
        if (this.message.getCommand().getParameterValue("_template") != null) {
            return this.create();
        }
        TemplateSelectorFactory factory = TemplateSelectorFactory.createInstance();
        String className = this.message.getCommand().getParameterValue("selector");
        List selections = null;
        try {
            ITemplateSelector selector = factory.getTemplateSelector(className);
            LOGGER.debug((Object)("Template selector class name: " + selector.getClass().getName()));
            selections = selector.selectTemplates(this.message);
            if (selections == null) {
                throw new TemplateSelectionException("No templates were selected");
            }
        }
        catch (TemplateSelectionException e) {
            LOGGER.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)e);
            return this.createErrorResponse("Failed to create work order(s): " + e.getMessage());
        }
        String errors = "Failed to create work order for key(s):" + NEW_LINE;
        boolean failed = false;
        for (SelectorOutput selection : selections) {
            try {
                this.create(selection);
            }
            catch (Exception t) {
                failed = true;
                errors = errors + selection.getSelectionKey() + " - " + t.getMessage() + NEW_LINE;
                LOGGER.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)t);
            }
        }
        if (failed) {
            return this.createErrorResponse(errors);
        }
        WorkflowMessage response = this.createSuccessResponse();
        response.setPayload(this.message.getPayload());
        return response;
    }

    private void create(SelectorOutput selection) throws Exception {
        String key = selection.getSelectionKey();
        if (key == null) {
            throw new TemplateSelectionException("Template selector did not specify a key");
        }
        LOGGER.debug((Object)("Selection key: " + key));
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IProcessManagerService service = (IProcessManagerService)registry.lookup(IProcessManagerService.class);
        WorkflowTemplate definition = ((ITemplateService)registry.lookup(ITemplateService.class)).getTemplateBySelectorKey(key);
        if (definition == null) {
            throw new DriverRuntimeException("Failed to find template for selector key " + key);
        }
        ProcessPriority priority = this.getPriority(selection);
        Map variables = selection.getTemplateVariables();
        IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
        WorkflowProcess process = factory.create(this.getCreateId(), (ProcessDefinition)definition, priority, variables);
        CustomToken token = process.getRootToken();
        LOGGER.info((Object)("[Process] " + token + ", template " + definition.getName() + ", selection key: " + key));
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, definition.getStartState(), true, this.message));
        service.start(token);
    }

    private WorkflowMessage create() {
        WorkflowMessage response = null;
        try {
            ProcessPriority priority = this.getPriority();
            WorkflowTemplate template = this.getTemplate();
            Map variables = this.message.getParameters();
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IProcessManagerService service = (IProcessManagerService)registry.lookup(IProcessManagerService.class);
            IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
            WorkflowProcess process = factory.create(this.getCreateId(), (ProcessDefinition)template, priority, variables);
            CustomToken token = process.getRootToken();
            DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, template.getStartState(), true, this.message));
            service.start(token);
            response = this.createSuccessResponse();
            response.setKey(this.generateKey(token));
            response.setPayload(this.message.getPayload());
        }
        catch (CreateIdExistedException e) {
            String errorMsg = "Failed to create Work Order for message [" + this.message.getMessageUID() + "] due to create id[" + e.getCreateId() + "] is existed";
            response = this.createErrorResponse(errorMsg);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)e);
            response = this.createErrorResponse("Failed to create work order: " + e.getMessage());
        }
        return response;
    }

    private String getCreateId() {
        return this.message.getCreateId();
    }

    private ProcessPriority getPriority(SelectorOutput selection) {
        ProcessPriority priority = null;
        String priorityValue = this.message.getCommand().getParameterValue("priority");
        String className = this.message.getCommand().getParameterValue("prioritySelector");
        LOGGER.debug((Object)("Priority value from message: " + priorityValue));
        LOGGER.debug((Object)("Priority selector class name: " + className));
        if (priorityValue != null && !priorityValue.trim().equals("")) {
            priority = this.convertLegacyPriority(priorityValue);
        } else if (className != null && !className.trim().equals("")) {
            try {
                priority = this.convertLegacyPriority(this.getPrioritySelector(className).getPriority(selection, this.message).toString());
                LOGGER.debug((Object)("Priority selected by " + className + ": " + priority));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to get priority - " + e.getMessage()), (Throwable)e);
            }
        }
        if (priority == null) {
            LOGGER.debug((Object)"Defaulting to priority P10");
            priority = ProcessPriority.P10;
        }
        return priority;
    }

    private ProcessPriority convertLegacyPriority(String priorityValue) {
        ProcessPriority priority;
        switch (priorityValue.toUpperCase()) {
            case "LOWEST": {
                priority = ProcessPriority.P20;
                break;
            }
            case "LOW": {
                priority = ProcessPriority.P15;
                break;
            }
            case "NORMAL": {
                priority = ProcessPriority.P10;
                break;
            }
            case "HIGH": {
                priority = ProcessPriority.P5;
                break;
            }
            case "HIGHEST": {
                priority = ProcessPriority.P1;
                break;
            }
            default: {
                priority = this.parsePriority(priorityValue);
            }
        }
        return priority;
    }

    private ProcessPriority parsePriority(String priorityValue) {
        ProcessPriority priority = ProcessPriority.P10;
        try {
            priority = ProcessPriority.valueOf((String)priorityValue);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)("Failed to get priority - " + priorityValue + " is not a valid priority"), (Throwable)e);
        }
        return priority;
    }

    private IPrioritySelector getPrioritySelector(String className) throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("clientClassesDirectory");
        ClientExtensionClassLoader loader = new ClientExtensionClassLoader(dir, ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> clazz = loader.loadClass(className);
        Object obj = clazz.newInstance();
        return (IPrioritySelector)obj;
    }

    private ProcessPriority getPriority() {
        String priorityValue = this.message.getCommand().getParameterValue("priority");
        if (priorityValue == null || priorityValue.length() == 0) {
            return ProcessPriority.P10;
        }
        ProcessPriority priority = this.convertLegacyPriority(priorityValue);
        return priority;
    }

    private WorkflowTemplate getTemplate() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        String templateName = this.message.getCommand().getParameterValue("_template");
        WorkflowTemplate template = ((ITemplateService)registry.lookup(ITemplateService.class)).getTemplateByName(templateName);
        if (template == null) {
            throw new RuntimeException("Template not found - " + templateName);
        }
        return template;
    }

    private IMessageKey generateKey(CustomToken token) {
        return new DefaultMessageKeyGenerator().generate((Token)token);
    }
}

