/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.message.queue.FileMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.IFileMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.TimerFileWatcher;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import com.tandbergtv.workflow.util.ApplicationProperties;
import org.springframework.util.Assert;

public class FileMessageConsumerFactory {
    private FileMessageConsumerFactory() {
    }

    public static IFileMessageConsumer create() {
        IMessageProducer producer = ServiceLookup.findMessageProducerService();
        Assert.notNull((Object)producer, (String)"Cannot find the Message Producer service !");
        TimerFileWatcher fileWatcher = new TimerFileWatcher();
        FileMessageConsumer fileMessageConsumer = new FileMessageConsumer(producer, FileMessageConsumerFactory.getOffloadQueueDir(), fileWatcher);
        fileMessageConsumer.setClusterService(ServiceLookup.findClusterService());
        return fileMessageConsumer;
    }

    public static String getOffloadQueueDir() {
        String dir = null;
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (Exception e) {
            throw new IllegalStateException("Application install directory is not configured", e);
        }
        return dir;
    }
}

