/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.ericsson.cms.neptune.rabbitmq.service.ChannelConfiguationPolicy;
import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import com.tandbergtv.workflow.core.service.ServiceLookup;
import com.tandbergtv.workflow.driver.message.queue.IQueueSelector;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MessageReceiver {
    private static final Logger LOGGER = Logger.getLogger(MessageReceiver.class);
    private static final boolean AUTO_ACK = false;
    public static final int DEFAULT_RABBITMQ_CONSUMER_QOS = 10;
    private int rabbitMqConsumerQos = 10;
    private IQueueSelector queueSelector;
    private IRabbitMQService mqService;
    private long retryInterval = 3000L;
    private long connectionTimeout = 30000L;
    private boolean isAutoRecoveryEnabled = true;

    public MessageReceiver(IRabbitMQService mqService, IQueueSelector queueSelector) {
        this(mqService, queueSelector, 10);
    }

    public MessageReceiver(IRabbitMQService mqService, IQueueSelector queueSelector, int qos) {
        this.mqService = mqService;
        this.queueSelector = queueSelector;
        this.rabbitMqConsumerQos = qos;
        this.retryInterval = mqService.getConfiguration().getNetworkRecoveryInterval();
        this.isAutoRecoveryEnabled = mqService.getConfiguration().isAutoRecoveryEnabled();
    }

    public void start() {
        this.mqService.addChannelConfigurationPolicy(new ChannelConfiguationPolicy(){

            public void configure(Channel channel) {
                try {
                    channel.basicQos(MessageReceiver.this.rabbitMqConsumerQos);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to set QOS for channel", (Throwable)e);
                }
            }
        });
        try {
            this.mqService.start();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to start the connection to RabbitMQ, try to reconnect  it 10 times ");
            this.recoveryConnection();
        }
    }

    private void recoveryConnection() {
        if (!this.isAutoRecoveryEnabled) {
            return;
        }
        Boolean started = (Boolean)ServiceLookup.forceExecute(() -> {
            this.mqService.recoverConnection();
            return true;
        }, (String)"creat the connection to RabbitMQ ", (long)this.connectionTimeout, (long)this.retryInterval);
        if (started == null || !started.booleanValue()) {
            throw new IllegalStateException("Failed to connect to RabbitMQ after a few retries in " + this.connectionTimeout + " ms.");
        }
    }

    public void stop() {
        LOGGER.info((Object)"Close the channel to RabbitMQ for service: ");
        try {
            if (this.mqService != null) {
                this.mqService.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to close the channel to RabbitMQ: ", (Throwable)e);
        }
    }

    public GetResponse nextMessage() throws IOException {
        GetResponse response;
        block1: {
            response = this.fetchMessage(this.queueSelector.getLastVisitedQueue());
            if (response != null) break block1;
            while (!this.queueSelector.isAllQueueVisted() && (response = this.fetchMessage(this.queueSelector.getNextPriorityQueue())) == null) {
            }
        }
        return response;
    }

    private int fetchQueueSize() {
        AMQP.Queue.DeclareOk dOk = null;
        try {
            dOk = this.getChannel().queueDeclarePassive(this.queueSelector.getLastVisitedQueue().toString());
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to fetch queue info", (Throwable)e);
        }
        return dOk == null ? -1 : dOk.getMessageCount();
    }

    public int getQueueSize() {
        int queueSize = 0;
        try {
            queueSize = this.fetchQueueSize();
        }
        catch (AlreadyClosedException e) {
            this.handleRecovery(e);
            queueSize = this.fetchQueueSize();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to fetch message from RabbitMQ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        return queueSize;
    }

    private GetResponse fetchMessage(WorkflowQueueType workflowQueueType) {
        GetResponse response = null;
        try {
            response = this.receiveMessageFromChannel(workflowQueueType);
        }
        catch (AlreadyClosedException e) {
            this.handleRecovery(e);
            response = this.receiveMessageFromChannel(workflowQueueType);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to fetch message from RabbitMQ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        return response;
    }

    private void handleRecovery(AlreadyClosedException e) {
        if (!this.isAutoRecoveryEnabled) {
            throw new IllegalStateException("Failed to connect to RabbitMQ", e);
        }
        String msg = "Cannot connect to RabbitMQ due to error:" + e.getMessage() + ", try to re-setup the connection.";
        LOGGER.error((Object)msg);
        this.recoveryConnection();
        LOGGER.info((Object)"Re-Connected to RabbitMQ after last failure, fetching message now");
    }

    private GetResponse receiveMessageFromChannel(WorkflowQueueType workflowQueueType) {
        try {
            Channel channel = this.getChannel();
            return channel.basicGet(workflowQueueType.getValue(), false);
        }
        catch (AlreadyClosedException e) {
            LOGGER.debug((Object)"Channel is closed", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to connect to RabbitMQ", e);
        }
    }

    public Channel getChannel() throws IOException {
        return this.mqService.getChannel();
    }

    public int getRabbitMqConsumerQos() {
        return this.rabbitMqConsumerQos;
    }

    public void setRabbitMqConsumerQos(int rabbitMqConsumerQos) {
        this.rabbitMqConsumerQos = rabbitMqConsumerQos;
    }

    public boolean isAutoRecoveryEnabled() {
        return this.isAutoRecoveryEnabled;
    }

    public void setQueueSelector(IQueueSelector queueSelector) {
        this.queueSelector = queueSelector;
    }
}

