/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.driver.message.queue.IQueueSelector;
import java.util.Map;

public class RotationalQueueSelector
implements IQueueSelector {
    private volatile WorkflowQueueType currentQueue = WorkflowQueueType.COMPLETION;
    private volatile WorkflowQueueType lastVistedQueue;
    private volatile WorkflowQueueType previousVistedQueue;
    private static Map<WorkflowQueueType, WorkflowQueueType> sequences = Maps.newConcurrentMap();

    public void setCurrentQueue(WorkflowQueueType lastVistedQueue) {
        this.currentQueue = lastVistedQueue;
    }

    @Override
    public WorkflowQueueType getLastVisitedQueue() {
        if (this.currentQueue != null) {
            this.lastVistedQueue = this.currentQueue;
        }
        this.lastVistedQueue = this.lastVistedQueue == null ? WorkflowQueueType.COMPLETION : this.lastVistedQueue;
        this.currentQueue = null;
        return this.lastVistedQueue;
    }

    @Override
    public WorkflowQueueType getNextPriorityQueue() {
        if (this.currentQueue == null) {
            this.currentQueue = this.lastVistedQueue;
        }
        this.previousVistedQueue = this.currentQueue;
        this.currentQueue = sequences.get(this.currentQueue);
        return this.currentQueue;
    }

    @Override
    public boolean isAllQueueVisted() {
        return WorkflowQueueType.COMPLETION == this.currentQueue && this.previousVistedQueue != WorkflowQueueType.COMPLETION;
    }

    static {
        sequences.put(WorkflowQueueType.COMPLETION, WorkflowQueueType.RESUMED);
        sequences.put(WorkflowQueueType.RESUMED, WorkflowQueueType.OTHER);
        sequences.put(WorkflowQueueType.OTHER, WorkflowQueueType.COMPLETION);
    }
}

