/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.internal.Files;
import com.tandbergtv.workflow.driver.template.watch.AbstractFileListener;
import com.tandbergtv.workflow.driver.template.watch.FileReader;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileListener
extends AbstractFileListener {
    private static final Logger LOGGER = Logger.getLogger(FileListener.class);

    @Override
    public void fileCreated(FileInfo fileInfo) {
        String filePath = fileInfo.getAbsolutePath();
        String fileExtension = FilenameUtils.getExtension((String)filePath);
        if ("xml".equals(fileExtension)) {
            super.fileCreated(fileInfo);
        } else {
            LOGGER.warn((Object)("The file type of the template file: '" + fileInfo.getName() + "' is not supported, we only support xml/par type, reject the ingestion."));
            if (!Files.reject((File)new File(filePath))) {
                LOGGER.warn((Object)("Failed to move unknown Template file " + filePath));
            }
        }
    }

    @Override
    protected ITemplateReader getReader(File file) {
        return new FileReader(file);
    }
}

