/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.exe.email.IEmailService;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class SimpleEmailService
implements IEmailService {
    private static final Logger LOGGER = Logger.getLogger(SimpleEmailService.class);
    private volatile Session session;
    private LinkedBlockingQueue<Message> messageQueue = new LinkedBlockingQueue(10000);
    private Scheduler<Void> senderScheduler = new Scheduler("simple-email-service", 1, 1);
    private boolean stopped = false;
    private long schduleDelayTime = 5000L;

    public String getServiceName() {
        return SimpleEmailService.class.getName();
    }

    public void start() {
        LOGGER.info((Object)"SimpleEmailService started");
        this.stopped = false;
        this.senderScheduler.schedule(() -> this.pullMessage(), this.schduleDelayTime);
    }

    private Void pullMessage() {
        while (!this.stopped) {
            try {
                Message msg = this.messageQueue.take();
                if (this.session == null) {
                    this.messageQueue.add(msg);
                    LOGGER.warn((Object)"Email session is not created, sleep 5 seconds for retring");
                    Thread.sleep(5000L);
                    continue;
                }
                this.sendMessage(msg);
            }
            catch (InterruptedException msg) {
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to send message : ", (Throwable)e);
            }
        }
        return null;
    }

    public void stop() {
        this.stopped = true;
        this.senderScheduler.stop();
        this.messageQueue.clear();
        LOGGER.info((Object)"SimpleEmailService stopped");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void send(Address[] recipients, String subject, String content) throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom();
        message.setRecipients(MimeMessage.RecipientType.TO, recipients);
        message.setSubject(subject);
        message.setText(content);
        this.addIntoQueue((Message)message);
    }

    void addIntoQueue(Message message) {
        this.messageQueue.add(message);
    }

    void sendMessage(Message message) throws MessagingException {
        Transport.send((Message)message);
        LOGGER.debug((Object)("One message has been delived. sub:" + message.getSubject() + " from:" + message.getFrom()));
    }

    public void updateSetting(Map<String, String> settings) {
        Properties props = new Properties();
        props.put("mail.smtp.host", settings.get("mail_smtp_host"));
        props.put("mail.smtp.port", (Object)Configuration.toInteger((String)settings.get("mail_smtp_port"), (int)25));
        props.put("mail.from", settings.get("mail_from"));
        this.session = Session.getInstance((Properties)props);
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public void setSchduleDelayTime(long schduleDelayTimeInMS) {
        this.schduleDelayTime = schduleDelayTimeInMS;
    }
}

