/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogEventListener;
import com.tandbergtv.workflow.log.SortColumnEnum;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.file.FileLogsGarbageCollector;
import com.tandbergtv.workflow.log.file.GarbageCollector;
import com.tandbergtv.workflow.log.file.LogReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.transport.TransportClient;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class WorkflowLogService
implements Service {
    private LogEventListener listener;
    private GarbageCollector collector;
    private Scheduler<Void> scheduler;
    private Scheduler<Void> fileLogscheduler;
    private long period;
    private LogReader logReader;
    private FileLogsGarbageCollector fileLogsCollector;
    private static final int MAX_LIMIT_FOR_LOGS = 2000;

    public WorkflowLogService(SessionFactory sessionFactory, String rootdir, Long period, Long window, int threads, TransportClient client) {
        Finder finder = new Finder(sessionFactory);
        this.listener = new LogEventListener(threads);
        this.collector = new GarbageCollector(window, client);
        this.scheduler = new Scheduler("log-delete", 1, 1);
        this.fileLogscheduler = new Scheduler("file-log-delete", 1, 1);
        this.logReader = new LogReader(rootdir, client);
        this.fileLogsCollector = new FileLogsGarbageCollector(rootdir, window, finder);
        this.period = period;
    }

    public void start() {
        DefaultMediator.getInstance().register((IColleague)this.listener);
    }

    @Deprecated
    public void startGCOnMaster() {
        this.scheduler.start();
        this.scheduler.schedule((Runnable)this.collector, 0L, this.period * 1000L);
        this.fileLogscheduler.start();
        this.fileLogscheduler.schedule((Runnable)this.fileLogsCollector, TimeUnit.DAYS.toSeconds(2L) * 1000L, TimeUnit.DAYS.toSeconds(30L) * 1000L);
    }

    public void stop() {
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this.listener);
    }

    public String getServiceName() {
        return "process-logger";
    }

    public List<NodeLog> findNodeLogs(WorkflowTemplate template, long processId, int start, int count) {
        List<ProcessLog> list;
        if (count == 0) {
            start = 0;
            count = 25;
        }
        return (list = this.getLogs(processId, NodeLog.class, this.findVisibleNodesID(template), start, count, false)).isEmpty() ? Collections.emptyList() : this.getNodeLogs(list);
    }

    public int getNodeLogCount(WorkflowTemplate template, long processId) {
        return this.getLogsCount(processId, NodeLog.class, this.findVisibleNodesID(template));
    }

    public List<MessageLog> findMessageLogs(long id, long nodeId, long logId, int count, int start, String orderBy, final boolean descending) {
        List<MessageLog> list = this.getMessageLogs(id, nodeId, logId, 0, 2000);
        if (list.isEmpty()) {
            return list;
        }
        final SortColumnEnum order = orderBy == null ? SortColumnEnum.timestamp : SortColumnEnum.valueOf(orderBy);
        Collections.sort(list, new Comparator<MessageLog>(){

            @Override
            public int compare(MessageLog m1, MessageLog m2) {
                return MessageLog.compare(m1, m2, order, descending);
            }
        });
        return this.subList(list, start, count == 0 ? 10000 : count);
    }

    public int getMessageLogsCount(long id, long nodeId, long logid) {
        return this.getMessageLogs(id, nodeId, logid, 0, 2000).size();
    }

    public long getCurrentNodeMessageLogId(long id, long nodeId) {
        List<ProcessLog> logs = this.getLogs(id, MessageLog.class, new HashSet<Long>(Arrays.asList(nodeId)), 0, 1, true);
        ProcessLog log = (ProcessLog)Iterables.getFirst(logs, null);
        return log == null ? 0L : log.getId();
    }

    public int[] getTaskNodeIteration(long id, long nodeId, long logid) {
        List<ProcessLog> logs = this.getLogs(id, NodeLog.class, Sets.newHashSet((Object[])new Long[]{nodeId}), 0, 2000, false);
        if (logs.isEmpty()) {
            return new int[]{0, 0};
        }
        return new int[]{logs.indexOf(this.findById(logs, logid)) + 1, logs.size()};
    }

    private List<MessageLog> getMessageLogs(long id, long nodeId, long time, int start, int count) {
        ArrayList<MessageLog> logs = new ArrayList<MessageLog>();
        List<ProcessLog> list = this.getLogs(id, this.types(), Sets.newHashSet((Object[])new Long[]{nodeId}), start, count);
        if (list.isEmpty()) {
            return logs;
        }
        ProcessLog log = this.findById(list, time);
        int index = list.indexOf(log);
        for (int i = index + 1; i < list.size(); ++i) {
            ProcessLog l = list.get(i);
            if (l instanceof NodeLog) {
                return logs;
            }
            logs.add((MessageLog)((Object)MessageLog.class.cast(l)));
        }
        return logs;
    }

    private ProcessLog findById(List<ProcessLog> logs, long id) {
        for (ProcessLog log : logs) {
            if (!(log instanceof NodeLog) || log.getId() != id) continue;
            return log;
        }
        return null;
    }

    private Set<Long> findVisibleNodesID(WorkflowTemplate template) {
        final LinkedHashSet nodes = Sets.newLinkedHashSet();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                nodes.add(node.getId());
            }
        });
        return nodes;
    }

    private Collection<Class<? extends ProcessLog>> types() {
        HashSet<Class<? extends ProcessLog>> types = new HashSet<Class<? extends ProcessLog>>();
        types.add(NodeLog.class);
        types.add(MessageLog.class);
        return types;
    }

    private List<NodeLog> getNodeLogs(List<ProcessLog> list) {
        ArrayList<NodeLog> copy = new ArrayList<NodeLog>();
        for (ProcessLog log : list) {
            copy.add((NodeLog)log);
        }
        return copy;
    }

    private int getLogsCount(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds) {
        return this.logReader.count(id, type, nodeIds);
    }

    private List<ProcessLog> getLogs(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds, int start, int count, boolean descending) {
        return this.logReader.getLogs(id, type, nodeIds, start, count, descending);
    }

    private List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count) {
        return this.logReader.getLogs(id, types, nodeIds, start, count, true);
    }

    private List<?> subList(List<?> list, int start, int count) {
        int end = list.size() - start < count ? list.size() : start + count;
        return list.subList(start, end);
    }
}

