/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.command;

import com.tandbergtv.workflow.driver.message.queue.MessageQueueFactory;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.CompositeCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import org.apache.log4j.Logger;

public class CommandFilter
extends CompositeCommand {
    private static final long serialVersionUID = -8015858506276540258L;
    private static final Logger LOGGER = Logger.getLogger(CommandFilter.class);
    private IMessageProducer messageProducer;

    public CommandFilter(ICommand command) {
        super(command);
    }

    public WorkflowMessage execute() {
        WorkflowMessage response;
        if (!this.filter()) {
            return super.execute();
        }
        String errorMessage = "";
        try {
            this.getMessageProducer().publish(ComponentType.WORKFLOW_SOAPFACADE, this.message);
            response = this.createSuccessResponse();
            response.setPayload(this.message.getPayload());
        }
        catch (Exception e) {
            errorMessage = "Lost message while saving [" + this.message.getMessageUID() + "]";
            response = this.createErrorResponse(errorMessage);
            LOGGER.error((Object)errorMessage, (Throwable)e);
        }
        return response;
    }

    private boolean filter() {
        if (this.command instanceof AbstractCommand) {
            return ((AbstractCommand)AbstractCommand.class.cast(this.command)).isThrottle();
        }
        return false;
    }

    public void setCommand(ICommand command) {
        this.command = command;
    }

    public void setMessage(WorkflowMessage message) {
        this.message = message;
    }

    public IMessageProducer getMessageProducer() {
        if (this.messageProducer == null) {
            this.messageProducer = MessageQueueFactory.lookupMessageProducer();
        }
        return this.messageProducer;
    }

    public void setMessageProducer(IMessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }
}

