/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.command.internal;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.driver.message.queue.RejectExecutionMessageExecption;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.CommandException;
import com.tandbergtv.workflow.message.command.CommandNotFoundException;
import com.tandbergtv.workflow.message.command.CompositeCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.springframework.util.Assert;

public class CommandExecutor
implements ICommandExecutor,
Service {
    private static final String PLUGIN_ID = "com.tandbergtv.workflow.message";
    private static final String EXTENSION_POINT = "command";
    private static final String DECORATOR_EXTENSION_POINT = "decorator";
    private static final String DECORATOR_COMMAND = "decorator";
    private static final String THROTTLE_PARAMETER = "throttle";
    private static final String ALIAS_PARAMETER = "alias";
    private static final String CLASS_PARAMETER = "class";
    private static final Logger LOGGER = Logger.getLogger(CommandExecutor.class);

    public WorkflowMessage execute(WorkflowMessage message) {
        WorkflowMessage response = null;
        long start = System.currentTimeMillis();
        ICommand cmd = this.getCommand(message);
        LOGGER.debug((Object)("Time taken to getCommand[" + cmd.getClass().getName() + "] - time:" + (System.currentTimeMillis() - start)));
        try {
            LOGGER.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            start = System.currentTimeMillis();
            response = this.getDecoratedCommand(cmd).execute();
            LOGGER.debug((Object)("Time taken to getDecodedCommand.execute[" + cmd.getClass().getName() + "] - time:" + (System.currentTimeMillis() - start)));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), (Throwable)e);
        }
        return response;
    }

    public WorkflowMessage executeImmediate(WorkflowMessage message) {
        WorkflowMessage response = null;
        ICommand cmd = this.getCommand(message);
        Assert.notNull((Object)cmd, (String)("Cannot find command by name:" + message.getCommandName() + " for messagee:" + message));
        try {
            LOGGER.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            response = cmd.execute();
            LOGGER.debug((Object)("Got response for command execution:" + response));
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), (Throwable)e);
        }
        return response;
    }

    public String getServiceName() {
        return "Command Executor";
    }

    public void start() {
    }

    public void stop() {
    }

    private ICommand getCommand(WorkflowMessage message) {
        ICommand cmd = null;
        WPCLCommand command = WPCLCommand.NULL;
        if (message.getCommand() != null) {
            command = message.getCommand();
        }
        try {
            Extension extension = this.getCommandExtension(command.getName());
            cmd = this.createCommand(extension, message);
            Extension decoratorExtension = this.getCommandDecoratorExtension(extension);
            if (decoratorExtension != null) {
                return this.createCompositeCommand(decoratorExtension, cmd);
            }
        }
        catch (CommandNotFoundException e) {
            throw new RejectExecutionMessageExecption(e.getMessage());
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Could not get command for message " + message.getMessageUID(), (Throwable)e);
        }
        return cmd;
    }

    private Extension getCommandDecoratorExtension(Extension e) {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = pm.getRegistry().getExtensionPoint(PLUGIN_ID, "decorator");
        for (Extension extension : point.getAvailableExtensions()) {
            Extension.Parameter param = extension.getParameter("extension-id");
            if (param == null || !e.getId().equalsIgnoreCase(param.valueAsString())) continue;
            return extension;
        }
        return null;
    }

    private ICommand createCommand(Extension extension, WorkflowMessage message) {
        ICommand command = null;
        try {
            Extension.Parameter parameter;
            String className = extension.getParameter(CLASS_PARAMETER).valueAsString();
            PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
            PluginManager pm = Platform.getPlatform().getPluginManager();
            Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
            Constructor ctor = clazz.getConstructor(WorkflowMessage.class);
            command = (ICommand)ctor.newInstance(message);
            if (command instanceof AbstractCommand && (parameter = extension.getParameter(THROTTLE_PARAMETER)) != null) {
                ((AbstractCommand)AbstractCommand.class.cast(command)).setThrottle(parameter.valueAsBoolean().booleanValue());
            }
        }
        catch (Exception e) {
            String commandName = message == null ? "Unknown Command" : message.getCommandName();
            LOGGER.error((Object)"Failed to create Command Object:", (Throwable)e);
            throw new CommandNotFoundException("Cannot create Command[" + commandName + "]", commandName);
        }
        return command;
    }

    private ICommand getDecoratedCommand(ICommand decoratee) throws Exception {
        Extension extension = this.getCommandExtension("decorator");
        if (extension == null) {
            return decoratee;
        }
        return this.createCompositeCommand(extension, decoratee);
    }

    private CompositeCommand createCompositeCommand(Extension extension, ICommand decoratee) throws Exception {
        String className = extension.getParameter(CLASS_PARAMETER).valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
        Constructor ctor = clazz.getConstructor(ICommand.class);
        return (CompositeCommand)ctor.newInstance(decoratee);
    }

    private Extension getCommandExtension(String name) {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = pm.getRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT);
        for (Extension extension : point.getAvailableExtensions()) {
            Extension.Parameter parameter = extension.getParameter(ALIAS_PARAMETER);
            if (!name.equalsIgnoreCase(parameter.valueAsString())) continue;
            return extension;
        }
        throw new CommandNotFoundException("Command[" + name + "] not found in Plugin.xml: ", name);
    }
}

