/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.process.ratelimiter.IRateLimiter;
import com.tandbergtv.workflow.process.ratelimiter.ThresholdSetting;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class RateLimiterSettingUpdateListener
implements ISettingUpdateListenter {
    private static final Logger LOGGER = Logger.getLogger(RateLimiterSettingUpdateListener.class);
    public static final String WORKFLOW_APPLICATION_PATH = "com.tandbergtv.workflow.application";

    @Override
    public String getPath() {
        return WORKFLOW_APPLICATION_PATH;
    }

    @Override
    public void changed(Map<String, String> setting) {
        IRateLimiter rateLimiter = ServiceLookup.lookupRateLimiter((long)5000L, (long)500L);
        Assert.notNull((Object)rateLimiter, (String)"Cannot find the RateLimter Plugin");
        RateLimiterSettingUpdateListener.update(rateLimiter, setting);
    }

    public static void update(IRateLimiter rateLimiter, Map<String, String> settings) {
        Map thresholds = ThresholdSetting.build(settings);
        if (thresholds.isEmpty()) {
            LOGGER.warn((Object)("Cannot find valid threshold setting for RateLimiter: " + Watch.toString(settings)));
            return;
        }
        rateLimiter.setThresholds(thresholds);
        IProcessManagerService pm = (IProcessManagerService)ServiceLookup.forceExecute(() -> ServiceLookup.findProcessManagerService(), (String)"Look up Process Manager", (long)5000L, (long)1000L);
        Assert.notNull((Object)pm, (String)"Cannot find Process Manager service.");
        int threadPoolMaxSize = rateLimiter.getThresholdSetting().calculateThreadPoolSize();
        pm.setTokenThreadPoolSize(threadPoolMaxSize, 50);
        LOGGER.debug((Object)("Update the Rate Limiter threshold setting : " + Watch.toString((Map)thresholds)));
    }
}

