/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.neptune;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ServicePropertyFileLoader {
    private static final Logger LOGGER = Logger.getLogger(ServicePropertyFileLoader.class);
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String WORKFLOW_CONF_DIR = "/conf/workflow";
    private static final String SERVICE_PROPERTIES = "/service.properties";

    public static Properties getProperties() {
        return ServicePropertyFileLoader.getProperties(WORKFLOW_CONF_DIR, SERVICE_PROPERTIES);
    }

    public static Properties getProperties(String componentConfDir, String componentServiceFile) {
        Properties prop = new Properties();
        File file = new File(System.getProperty(PRODUCT_DIR) + componentConfDir, componentServiceFile);
        try {
            if (file.exists()) {
                prop = PropertiesLoaderUtils.loadProperties((Resource)new FileSystemResource(file));
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)("Failed to load property files + " + file.getAbsolutePath()), (Throwable)e);
        }
        return prop;
    }
}

