/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class DatatypeConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TIME_FORMAT_LONG = "dd'T'HH:mm:ss";

    public static Object convert(Object input, Datatype type) throws TypeConversionException {
        Assert.notNull((Object)input, (String)"The value to be converted cannot be null");
        Object ret = input.toString();
        String value = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(value);
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(value);
                    break;
                }
                case DATE: {
                    ret = DatatypeConverter.toDate(input, value);
                    break;
                }
                case DURATION: {
                    DatatypeConverter.validateDateFormat(value);
                    break;
                }
                case LIST: {
                    ret = DatatypeConverter.toList(input);
                    break;
                }
                case LONG: {
                    ret = Long.valueOf(value);
                    break;
                }
                case DOUBLE: {
                    ret = Double.valueOf(value);
                    break;
                }
                case FLOAT: {
                    ret = Float.valueOf(value);
                    break;
                }
                case BYTE: {
                    ret = Byte.valueOf(value);
                    break;
                }
                case CHAR: {
                    ret = Character.valueOf(value.charAt(0));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + DatatypeConverter.getValueDisplayStr(input) + " to " + (Object)((Object)type) + " Type. ", e);
        }
        return ret;
    }

    private static Object toDate(Object input, String value) throws TypeConversionException {
        if (input instanceof Long || input instanceof String && DatatypeConverter.isLongValueString(input)) {
            return new Timestamp(Configuration.toLong(value, -1L));
        }
        return input instanceof Date ? input : DatatypeConverter.parseDate(DATE_FORMAT, value);
    }

    private static boolean isLongValueString(Object input) {
        return Objects.toString(input, "").length() >= 8 && Configuration.toLong(input, -1L) != -1L;
    }

    private static ArrayList<?> toList(Object input) {
        if (DatatypeConverter.isNotString(input)) {
            return (ArrayList)input;
        }
        String stringValue = Objects.toString(input, "");
        if (DatatypeConverter.isStandardJsonString(stringValue)) {
            return DatatypeConverter.toStandardJsonStringList(stringValue);
        }
        ArrayList<String> result = null;
        if (stringValue.trim().equals("[]")) {
            result = new ArrayList<String>();
        }
        if (stringValue.trim().startsWith("[")) {
            stringValue = StringUtils.removeStart((String)stringValue.trim(), (String)"[");
            stringValue = StringUtils.removeEnd((String)stringValue, (String)"]");
        }
        if (!stringValue.isEmpty()) {
            result = new ArrayList();
            String[] elements = stringValue.split(",");
            for (int i = 0; i < elements.length; ++i) {
                boolean isEmptyString = StringUtils.isBlank((String)elements[i]) && elements[i].length() > 0;
                String element = isEmptyString ? elements[i] : elements[i].trim();
                result.add(element);
            }
        }
        return result;
    }

    private static boolean isStandardJsonString(String stringValue) {
        return stringValue.contains("\"") || stringValue.contains("'");
    }

    private static boolean isNotString(Object input) {
        return !(input instanceof String);
    }

    private static ArrayList<?> toStandardJsonStringList(String stringValue) {
        return (ArrayList)JsonObjectMapper.toList(stringValue, String.class);
    }

    private static String getValueDisplayStr(Object input) {
        String className;
        String string = className = input == null ? "" : input.getClass().getSimpleName() + ":";
        String valueStr = input instanceof String ? (StringUtils.isBlank((String)input.toString()) ? "\"\"" : input.toString()) : Objects.toString(input, " Null value");
        return className + valueStr;
    }

    public static String convertToString(Object input, Datatype type) {
        String result = null;
        try {
            if (type == Datatype.DATE) {
                result = Objects.toString(DatatypeConverter.convertToDate(input).getTime(), null);
            } else if (type == Datatype.LIST) {
                ArrayList<?> list = DatatypeConverter.convertToList(input);
                result = JsonObjectMapper.toJsonString(list);
            } else {
                result = Objects.toString(DatatypeConverter.convert(input, type), null);
            }
        }
        catch (TypeConversionException typeConversionException) {
            // empty catch block
        }
        return result;
    }

    public static Integer convertToInt(Object input) throws TypeConversionException {
        return ((Number)DatatypeConverter.convert(input, Datatype.INT)).intValue();
    }

    public static Long convertToLong(Object input) throws TypeConversionException {
        return ((Number)DatatypeConverter.convert(input, Datatype.LONG)).longValue();
    }

    public static Double convertToDouble(Object input) throws TypeConversionException {
        return ((Number)DatatypeConverter.convert(input, Datatype.DOUBLE)).doubleValue();
    }

    public static Float convertToFloat(Object input) throws TypeConversionException {
        return Float.valueOf(((Number)DatatypeConverter.convert(input, Datatype.FLOAT)).floatValue());
    }

    public static Byte convertToByte(Object input) throws TypeConversionException {
        return ((Number)DatatypeConverter.convert(input, Datatype.BYTE)).byteValue();
    }

    public static Character convertToChar(Object input) throws TypeConversionException {
        return (Character)DatatypeConverter.convert(input, Datatype.CHAR);
    }

    public static Boolean convertToBoolean(Object input) throws TypeConversionException {
        return (Boolean)DatatypeConverter.convert(input, Datatype.BOOLEAN);
    }

    public static Date convertToDate(Object input) throws TypeConversionException {
        return (Date)DatatypeConverter.convert(input, Datatype.DATE);
    }

    public static ArrayList<?> convertToList(Object input) throws TypeConversionException {
        return (ArrayList)DatatypeConverter.convert(input, Datatype.LIST);
    }

    private static void validateDateFormat(String value) throws TypeConversionException {
        String[] parts = StringUtils.split((String)value, (String)",");
        String format = parts[0].length() == TIME_FORMAT.length() ? TIME_FORMAT : TIME_FORMAT_LONG;
        DatatypeConverter.parseDate(format, value);
    }

    private static DateFormat dateFormatterFor(String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        f.setLenient(false);
        return f;
    }

    private static Date parseDate(String format, String value) throws TypeConversionException {
        String[] parts = StringUtils.split((String)value, (String)",");
        DateFormat dateFormat = DatatypeConverter.dateFormatterFor(format);
        String toParse = null;
        try {
            String[] stringArray = parts;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String part;
                toParse = part = stringArray[i];
                dateFormat.parse(toParse);
            }
            toParse = parts[0];
            return dateFormat.parse(toParse);
        }
        catch (ParseException e) {
            String message = "Invalid format for value [" + toParse + "], It should follow format " + format;
            throw new TypeConversionException(message);
        }
    }
}

