/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.util.SessionUtils;
import com.tandbergtv.workflow.driver.internal.ICustomTokenDTOService;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class CustomTokenDTOService
implements ICustomTokenDTOService {
    private static final Logger logger = Logger.getLogger(CustomTokenDTOService.class);
    private SessionFactory sessionFactory;

    public CustomTokenDTOService(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void create(CustomTokenDTO dto) {
        Session session = this.sessionFactory.getCurrentSession();
        dto.setOperationalStatus(CustomTokenDTOService.exractOperationStatus(dto.getOperationalStatus()));
        dto.setAdminStatus(CustomTokenDTOService.extractAdminStatus(dto.getAdminStatus()));
        session.save((Object)dto);
        logger.debug((Object)("CustomTokenDTO is saved to datebase: " + dto.toString()));
    }

    private static ProcessStatus extractAdminStatus(ProcessStatus processStatus) {
        return processStatus == null ? ProcessStatus.CREATED : processStatus;
    }

    private static ProcessStatus exractOperationStatus(ProcessStatus processStatus) {
        return processStatus == null ? ProcessStatus.CREATED : processStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomTokenDTO getToken(long tokenId) {
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            CustomTokenDTO customTokenDTO = (CustomTokenDTO)session.load(CustomTokenDTO.class, (Serializable)Long.valueOf(tokenId));
            return customTokenDTO;
        }
        catch (Exception oe) {
            logger.warn((Object)("Get CustomTokenDTO failed: " + oe));
            CustomTokenDTO customTokenDTO = null;
            return customTokenDTO;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    @Override
    public void save(CustomTokenDTO dto) {
        Session session = this.sessionFactory.getCurrentSession();
        dto.setAdminStatus(CustomTokenDTOService.extractAdminStatus(dto.getAdminStatus()));
        dto.setOperationalStatus(CustomTokenDTOService.exractOperationStatus(dto.getOperationalStatus()));
        session.merge((Object)dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CustomTokenDTO> getChildTokens(long parentTokenId, long processId) {
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            String sql = "SELECT CT FROM CustomTokenDTO CT WHERE CT.parentTokenId >0 and CT.parentTokenId = ?  and CT.processId=? ";
            Query query = session.createQuery(sql);
            query.setParameter(0, (Object)parentTokenId);
            query.setParameter(1, (Object)processId);
            List customTokenDTOs = query.list();
            logger.debug((Object)(customTokenDTOs.size() + " child tokens found by parent token id: " + parentTokenId));
            List list = customTokenDTOs;
            return list;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }
}

