/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.process.ratelimiter.NumberUtils;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class DynamicThreadPoolSchedule<T>
extends Scheduler<T> {
    public DynamicThreadPoolSchedule(String name, int size, int max) {
        super(name, size, max);
    }

    public DynamicThreadPoolSchedule(String name, int size) {
        super(name, DynamicThreadPoolSchedule.generateCoreSize(size, 50), size);
    }

    public void setMaximumPoolSize(int maxThreads) {
        int corePoolSize = this.getExecutor().getCorePoolSize();
        if (corePoolSize > maxThreads) {
            corePoolSize = maxThreads;
            this.getExecutor().setCorePoolSize(corePoolSize > 0 ? corePoolSize : maxThreads);
        }
        this.getExecutor().setMaximumPoolSize(maxThreads);
    }

    public void setPoolSize(int max, int coreSizeRatioToMax) {
        int coreSize = DynamicThreadPoolSchedule.generateCoreSize(max, coreSizeRatioToMax);
        if (coreSize > this.getExecutor().getMaximumPoolSize()) {
            this.getExecutor().setMaximumPoolSize(max);
            this.getExecutor().setCorePoolSize(coreSize);
        } else {
            this.getExecutor().setCorePoolSize(coreSize);
            this.getExecutor().setMaximumPoolSize(max);
        }
    }

    protected ScheduledThreadPoolExecutor getExecutor() {
        return (ScheduledThreadPoolExecutor)super.getExecutor();
    }

    static int generateCoreSize(int max, int ratioToMax) {
        return ratioToMax > 100 ? max : NumberUtils.getPercentage((int)max, (int)ratioToMax);
    }
}

