/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.VariableInitializer;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.message.command.ICreateIdGenerator;
import com.tandbergtv.workflow.message.createid.CreateIDContextFactory;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessFactory
implements IProcessFactory {
    public WorkflowProcess create(ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) {
        return this.create(this.createUUID(), template, priority, parameters);
    }

    public WorkflowProcess create(String createId, ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) {
        WorkflowProcess process;
        if (StringUtils.isBlank((String)createId)) {
            createId = this.createUUID();
        }
        try {
            Map<String, Object> copy = this.getInitialVariables(template, parameters);
            process = new WorkflowProcess(createId, template, priority);
            for (String name : copy.keySet()) {
                process.getContextInstance().setVariable(name, copy.get(name));
            }
            this.postCreate(process);
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    private String createUUID() {
        return this.getCreateIdGenerator().newUUID();
    }

    public WorkflowProcess create(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        token.getProcessInstance().lock();
        try {
            Map<String, Object> copy = this.getInitialVariables(template, parameters);
            process = token.createSubProcessInstance(template);
            for (String name : copy.keySet()) {
                process.getContextInstance().setVariable(name, copy.get(name));
            }
            this.postCreate(process);
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(ErrorCategory.CHILD_PROCESS_LAUNCH_FAIL.name(), e);
        }
        finally {
            token.getProcessInstance().unlock();
        }
        return process;
    }

    public WorkflowProcess start(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        return this.start(false, token, template, parameters);
    }

    public WorkflowProcess start(boolean inLocalNode, CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = this.create(token, template, parameters);
        try {
            if (inLocalNode) {
                this.getProcessManagerService().startInLocalNode(process.getRootToken());
            } else {
                this.getProcessManagerService().start(process.getRootToken());
            }
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    protected void postCreate(WorkflowProcess process) {
        process.setLogLevel(this.getLogLevel());
        ProcessPersistenceService service = ServiceLookup.findProcessPersistenceService();
        service.create(process);
        this.getCounter().created(process.getRootToken());
    }

    protected LogLevel getLogLevel() {
        String level = this.getProcessManagerService().getProperties().getProperty("log.level", LogLevel.ALL.toString());
        return LogLevel.valueOf((String)level.toUpperCase());
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.getProcessManagerService().getStatistics().getCumulativeStatistics());
    }

    protected Map<String, Object> getInitialVariables(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        return new VariableInitializer(template, parameters).initialize();
    }

    private IProcessManagerService getProcessManagerService() {
        return ServiceLookup.findProcessManagerService();
    }

    private ICreateIdGenerator getCreateIdGenerator() {
        return CreateIDContextFactory.createJavaUUIDGenerator();
    }
}

