/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.task.DistributedLocalCallable;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class SignalSuperProcessToken
extends TokenCallable
implements DistributedLocalCallable<CustomToken> {
    private static final Logger LOGGER = Logger.getLogger(SignalSuperProcessToken.class);
    private long childPid;
    private static final long serialVersionUID = 3251238469812711918L;

    public SignalSuperProcessToken(CustomToken token, boolean usePid) {
        super(token);
        this.childPid = token.getSubProcessInstance().getId();
        if (usePid) {
            this.key = Long.valueOf(this.getPid());
        }
    }

    @Override
    public CustomToken call() throws Exception {
        CustomToken token = this.findToken();
        LOGGER.debug((Object)("Get Signaled by subprocess, super process token is " + token.toString()));
        if (!this.isSuperProcessToken(token)) {
            LOGGER.warn((Object)("Token<" + token + "> does not have child : " + this.childPid));
            return token;
        }
        try {
            WorkflowProcess child = this.getProcessPersistenceService().get(Long.valueOf(this.childPid));
            child.setSuperProcessToken((Token)token);
            token.setSubProcessInstance((ProcessInstance)child);
            this.cacheProcess(token);
            LOGGER.info((Object)("Completed: notify parent process : " + token));
            token.signal2();
        }
        catch (Throwable t) {
            LOGGER.error((Object)("Failed to notify parent process : " + token + ", child " + this.childPid), t);
        }
        return token;
    }

    private void cacheProcess(CustomToken token) {
        try {
            WorkflowProcess process = token.getProcessInstance();
            ServiceLookup.findProcessCacheService().add((Serializable)Long.valueOf(process.getId()), process);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to sync up the cache for Process:" + token), (Throwable)e);
        }
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        if (process == null) {
            return false;
        }
        return this.childPid == process.getId();
    }
}

