/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.task.DistributedCallable;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public abstract class TokenCallable
implements Serializable,
DistributedCallable<CustomToken> {
    private static final long serialVersionUID = 7600678204063487453L;
    protected long pid;
    protected long tokenId;
    protected Serializable key;
    private static final Logger LOGGER = Logger.getLogger(TokenCallable.class);

    protected TokenCallable() {
    }

    public TokenCallable(CustomToken token) {
        this.pid = token.getProcessInstance().getId();
        this.tokenId = token.getId();
        this.key = ProcessFinder.getKey(token.getProcessInstance());
    }

    public Object getKey() {
        return this.key;
    }

    protected long getPid() {
        return this.pid;
    }

    public CustomToken call() throws Exception {
        CustomToken token = null;
        try {
            token = this.findToken();
            this.schedule(this.innerCallable(token));
        }
        catch (Throwable t) {
            LOGGER.error((Object)("Could not run Token[" + this.getPid() + ":" + this.tokenId + "]"), t);
        }
        return token;
    }

    protected abstract Callable<CustomToken> innerCallable(CustomToken var1);

    protected void schedule(Callable<CustomToken> callable) {
        this.getScheduler().schedule(callable);
    }

    protected <T> CustomToken findToken() {
        WorkflowProcess process = (WorkflowProcess)ServiceLookup.forceExecute(this.findProcess(), (String)("find Process by Id:" + this.pid), (long)30000L, (long)1000L);
        Assert.notNull((Object)process, (String)("Cannot find Process by Id:" + this.pid));
        CustomToken token = process.findToken(this.tokenId);
        Assert.notNull((Object)token, (String)("Cannot find Token by id:" + this.tokenId));
        return token;
    }

    private Callable<WorkflowProcess> findProcess() {
        return new Callable<WorkflowProcess>(){

            @Override
            public WorkflowProcess call() throws Exception {
                return ServiceLookup.findProcessPersistenceService().get(Long.valueOf(TokenCallable.this.pid));
            }
        };
    }

    protected void handleStackOverflowError(CustomToken token, Throwable t) {
        LOGGER.warn((Object)(token + " overflowed stack"));
        token.fail(ErrorCategory.INFINITE_LOOP, t);
    }

    protected IProcessManagerService getProcessManagerService() {
        IProcessManagerService service = ServiceLookup.findProcessManagerService();
        if (service == null) {
            String msg = "ProcessManagerService is not ready yet, fail to execute the current Token[" + this.tokenId + "]";
            LOGGER.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return service;
    }

    protected ProcessPersistenceService getProcessPersistenceService() {
        return ServiceLookup.findProcessPersistenceService();
    }

    protected ISchedulerService<CustomToken> getScheduler() {
        return this.getProcessManagerService().getScheduler();
    }

    protected IProcessCounter counter() {
        IStatistics stats = this.getProcessManagerService().getStatistics();
        return (IProcessCounter)IProcessCounter.class.cast(stats.getCumulativeStatistics());
    }
}

