/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.driver.internal.monitor.MetricInfoType;
import com.tandbergtv.workflow.monitor.internal.LoggingRecorder;
import org.apache.log4j.Logger;

public class MetricLogger {
    private static final String METRIC_PREFIX = "application-metrics.workflow.";
    private volatile String logFormat = "";
    private static final Logger LOGGER = Logger.getLogger(LoggingRecorder.class);

    public MetricLogger(String typeString) {
        this.setMetricName(typeString);
    }

    public void setMetricName(String typeString) {
        this.logFormat = METRIC_PREFIX + typeString + ".%s.count %s %d";
    }

    public void setLogformat(String format) {
        this.logFormat = METRIC_PREFIX + format;
    }

    public void writeLog(MetricInfoType type, int count) {
        this.writeLog(type, Integer.toString(count));
    }

    public void writeLog(String type, long count) {
        this.writeLog(type, Long.toString(count));
    }

    public void writeLog(MetricInfoType type, long count) {
        this.writeLog(type, Long.toString(count));
    }

    public void writeLog(MetricInfoType type, String value) {
        this.writeLog(type.toString().toLowerCase(), value);
    }

    public void writeLog(String type, String value) {
        try {
            long timestamp = this.getTimestamp();
            LOGGER.info((Object)String.format(this.logFormat, type, value, timestamp));
        }
        catch (Exception t) {
            LOGGER.info((Object)"Error occurred while writing process status logs", (Throwable)t);
        }
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }
}

