/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process;

import com.google.common.base.Stopwatch;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.entity.WorkflowProcessDTO;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessConvertor;
import com.tandbergtv.workflow.driver.process.IProcessCoder;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.nustaq.serialization.FSTConfiguration;

public class ProcessCoderDefaultImpl
implements IProcessCoder {
    private static final Logger LOGGER = Logger.getLogger(ProcessCoderDefaultImpl.class);
    private static FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
    private WorkflowProcessConvertor processConvertor = null;
    private WorkflowProcessCache processCache = null;

    public ProcessCoderDefaultImpl() {
    }

    public ProcessCoderDefaultImpl(WorkflowProcessConvertor processConvertor) {
        this.processConvertor = processConvertor;
    }

    public void setProcessConvertor(WorkflowProcessConvertor processConvertor) {
        this.processConvertor = processConvertor;
    }

    public void setProcessCache(WorkflowProcessCache processCache) {
        this.processCache = processCache;
    }

    @Override
    public byte[] encode(WorkflowProcess process) {
        Stopwatch watch = Stopwatch.createStarted();
        WorkflowProcessDTO processDto = this.processConvertor.toProcessDTO(process);
        byte[] data = fstConf.asByteArray((Object)processDto);
        LOGGER.debug((Object)("Encode the Process + " + process + " size:" + data.length + "  into cache  in :" + Watch.cost((Stopwatch)watch)));
        return data;
    }

    @Override
    public WorkflowProcess decode(byte[] data) {
        Stopwatch watch = Stopwatch.createStarted();
        WorkflowProcessDTO processDto = (WorkflowProcessDTO)fstConf.asObject(data);
        WorkflowProcess process = this.processConvertor.toProcessObject(processDto);
        if (processDto.isSubprocess()) {
            WorkflowProcess topProcess = this.getProcessCache().get(Long.valueOf(processDto.getParentId()));
            if (topProcess != null) {
                CustomToken token = topProcess.findToken(processDto.getParentTokenId());
                process.setSuperProcessToken((Token)token);
            } else {
                LOGGER.debug((Object)("Cannot find the valid parent process in cache for current process: " + processDto.toString() + ". Probably it is not loaded to Process Cache."));
            }
        }
        LOGGER.debug((Object)("Decode the data from cache to Process + " + process + " size:" + data.length + " from cache  in :" + Watch.cost((Stopwatch)watch)));
        return process;
    }

    private WorkflowProcessCache getProcessCache() {
        if (this.processCache == null) {
            this.processCache = (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
        }
        return this.processCache;
    }
}

