/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.es.CmsTransportClient;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.hazelcast.core.ISet;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchFilterBuilder;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsPersistanceSynchronizer;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsProcessHelper;
import com.tandbergtv.workflow.driver.search.event.ProcessGUIPartialUpdateEvent;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.hibernate.SessionFactory;

public class WFSElasticSearchService
extends SearchService
implements IWFSElasticSearchPersistanceHelper,
IColleague {
    public static final int MAX_SEARCH_RESULT_SIZE = 10000;
    private static final Logger LOGGER = Logger.getLogger(WFSElasticSearchService.class);
    private static final boolean USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT = System.getProperty("workflow.elasticsearch.sync.util", "").isEmpty();
    private CmsTransportClient client;
    private WfsEsProcessHelper esProcessHelper = WfsEsProcessHelper.getInstance();
    private static final String SAVE_FAILED_MAP = "ES_SAVE_MAP";
    private static final String DELETE_FAILED_MAP = "ES_DELETE_MAP";
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private IWFSElasticSearchPersistanceHelper persistanceHelper;
    private Thread asyncESSynchronizer;
    private boolean running = true;
    private ISchedulerService<Void> scheduler;
    private BulkProcessor processor;
    private IClusterService clusterService;

    public WFSElasticSearchService(SessionFactory factory) {
        super(factory);
    }

    public WFSElasticSearchService(SessionFactory factory, IWorkOrderLoader workOrderLoader) {
        super(factory);
        this.setPersistenceService(workOrderLoader);
    }

    @Override
    public int count(ProcessStatus status) {
        return this.expressCount(this.getSearchCriteriaByProcessStatus(status));
    }

    @Override
    public int count(List<ProcessStatus> list) {
        return this.expressCount(this.getSearchCriteriaByProcessStatusList(list));
    }

    @Override
    public void start() {
        LOGGER.debug((Object)"Starting WFSElasticSearch service...");
        try {
            this.client = new CmsTransportClient(WFSElasticSearchService.getESPropertiesFileName());
            this.processor = BulkProcessor.builder((Client)this.client.getTransportClient(), (BulkProcessor.Listener)this.createListener()).setFlushInterval(TimeValue.timeValueSeconds((long)10L)).build();
            this.scheduler = new Scheduler("process-elasticsearch-save", 1, 1);
            this.scheduler.start();
            DefaultMediator.getInstance().register((IColleague)this);
            this.persistanceHelper = this;
            this.running = true;
            this.asyncESSynchronizer = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (WFSElasticSearchService.this.running) {
                        if (USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT && WFSElasticSearchService.this.getClusterService().isMaster()) {
                            WfsEsPersistanceSynchronizer synchronizer;
                            Long[] wip;
                            ISet failedSet = WFSElasticSearchService.this.getClusterService().getInstance().getSet(WFSElasticSearchService.DELETE_FAILED_MAP);
                            if (failedSet != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, true);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                            if ((failedSet = WFSElasticSearchService.this.getClusterService().getInstance().getSet(WFSElasticSearchService.SAVE_FAILED_MAP)) != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, false);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    WFSElasticSearchService.this.executor.shutdown();
                }
            });
            this.asyncESSynchronizer.start();
            LOGGER.debug((Object)"Started WFSElasticSearch service");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not connect to ElasticSearch.", (Throwable)e);
        }
    }

    public static String getESPropertiesFileName() {
        String dirName = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms");
        File file = new File(dirName, "/conf/workflow/WFSElasticSearch.properties");
        return file.getAbsolutePath();
    }

    @Override
    public void stop() {
        LOGGER.debug((Object)"Stopping ElasticSearch service...");
        this.scheduler.stop();
        if (this.asyncESSynchronizer != null) {
            this.asyncESSynchronizer.interrupt();
        }
        this.running = false;
        DefaultMediator.getInstance().unregister((IColleague)this);
        try {
            this.client.close();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        LOGGER.debug((Object)"Stopped ElasticSearch service.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String id = String.valueOf(process.getId());
        LOGGER.debug((Object)("Saving process[" + id + "]"));
        LOGGER.debug((Object)("Saving process[" + id + "] to es :\n " + source.string()));
        try (XContentBuilder source = this.esProcessHelper.createProcess(process);){
            this.processor.add((IndexRequest)this.client.prepareIndex("wfs", "processinstance", id).setSource(source).request());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WFSearchResult result) throws Exception {
        if (result == null || result.getProcessId() < 1L || result.getToken().getTokenId() < 1L) {
            return;
        }
        String procId = String.valueOf(result.getProcessId());
        LOGGER.debug((Object)("Saving process[" + procId + "]"));
        try (XContentBuilder source = this.esProcessHelper.createBuilder(result);){
            this.esProcessHelper.savingNoWait(procId, source, this.client.getTransportClient());
        }
    }

    private void saveFailedProcessId(long id, boolean deleting) {
        String flag;
        String string = flag = deleting ? "delete" : "save";
        if (!USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT) {
            String msg = "Failed attempt of saving process Id " + id + " to reindex later for " + flag + " operation.";
            LOGGER.fatal((Object)msg);
            throw new RuntimeException(msg);
        }
        LOGGER.info((Object)("Saving process Id " + id + " to reindex later for " + flag + " operation."));
        String key = deleting ? DELETE_FAILED_MAP : SAVE_FAILED_MAP;
        ISet failedSet = this.getClusterService().getInstance().getSet(key);
        failedSet.add(id);
    }

    @Override
    public void delete(long id) throws Exception {
        LOGGER.debug((Object)("Deleting process[" + id + "]"));
        String procId = String.valueOf(id);
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (!this.esProcessHelper.tryDeleting(procId, this.client.getTransportClient())) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stopwatch.start();
            if (stopwatch.elapsed(TimeUnit.MILLISECONDS) <= this.client.getSettings().getWriteTimeoutMs()) continue;
            this.saveFailedProcessId(id, true);
            return;
        }
    }

    @Override
    public void softDelete(long id) throws Exception {
        String procId = String.valueOf(id);
        XContentBuilder contentBuilder = JsonXContent.contentBuilder().startObject();
        contentBuilder.field("isActive", false);
        contentBuilder.endObject();
        UpdateRequest updateRequest = new UpdateRequest("wfs", "processinstance", procId);
        updateRequest.doc(contentBuilder);
        this.client.update(updateRequest).get(this.client.getSettings().getWriteTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria) {
        LOGGER.debug((Object)"Starting expressSearch --> ");
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> sortList = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereList = new ArrayList<SearchParameterBase>();
        boolean getChildren = false;
        for (SearchParameterBase param : searchParameters) {
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            if ("getChildren".equalsIgnoreCase(param.getFieldName())) {
                getChildren = true;
                continue;
            }
            whereList.add(param);
        }
        List<Object> results = Lists.newArrayList();
        if (getChildren) {
            WFSearchResult childProcess = this.expressSearchSubProcess(whereList);
            Optional.ofNullable(childProcess).ifPresent(results::add);
        } else {
            results = this.expressSearchTopLevelProcesses(searchCriteria, whereList, sortList);
        }
        return results;
    }

    private WFSearchResult expressSearchSubProcess(List<SearchParameterBase> whereList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long processId = this.findParentProcessId(whereList);
        boolean hidesubprocess = this.findField(whereList, "hidesubprocess") != null;
        WFSearchResult childProcess = this.loadProcess(processId, hidesubprocess);
        LOGGER.debug((Object)("Total getChildren: " + Watch.cost((Stopwatch)stopwatch)));
        return childProcess;
    }

    private WFSearchResult loadProcess(long processId, boolean hidesubprocess) {
        WorkflowProcess proc = this.loadWorkOrder(processId);
        if (proc == null) {
            return null;
        }
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(proc.getId());
        result.setProcessDefinitionName(proc.getProcessDefinition().getFullName());
        CustomToken sourceToken = proc.getRootToken();
        WFToken token = new WFToken();
        result.setToken(token);
        result.setRootTokenId(sourceToken.getId());
        this.refillToken(token, sourceToken);
        if (!hidesubprocess) {
            ArrayList processList = Lists.newArrayList((Iterable)proc.getSubProcessInstances());
            this.refillSubProcess(result, processList);
        }
        return result;
    }

    private void refillToken(WFToken targetToken, CustomToken sourceToken) {
        targetToken.setAdministrativeStatus(sourceToken.getRequestedStatus().ordinal());
        targetToken.setEndTime(sourceToken.getEnd());
        if (sourceToken.getErrorDetails() != null) {
            targetToken.setErrorComment(sourceToken.getErrorDetails().getMessage());
            targetToken.setErrorTime(sourceToken.getErrorDetails().getTime());
        }
        targetToken.setNodeName(sourceToken.getCurrentNode().getName());
        targetToken.setOperationalStatus(sourceToken.getStatus().ordinal());
        targetToken.setProcessId(sourceToken.getProcessInstance().getId());
        targetToken.setStartTime(sourceToken.getStart());
        targetToken.setTokenId(sourceToken.getId());
        this.refillChildrenToken(targetToken, sourceToken);
    }

    private void refillChildrenToken(WFToken targetToken, CustomToken sourceToken) {
        targetToken.getChildren().clear();
        for (CustomToken sourceChildToken : sourceToken.getChildTokens()) {
            WFToken wfChildToken = new WFToken();
            this.refillToken(wfChildToken, sourceChildToken);
            targetToken.addChild(wfChildToken);
        }
    }

    private void refillSubProcess(WFSearchResult result, List<WorkflowProcess> processList) {
        Set<Long> idSet = processList.stream().map(sc -> sc.getId()).collect(Collectors.toSet());
        List<WFSearchResult> esProcessList = this.fetchProcessinES(idSet);
        List<WFSearchResult> subProcessInNonBranchedNode = this.fetchSubProcessInES(result.getProcessId());
        if (!subProcessInNonBranchedNode.isEmpty()) {
            esProcessList.addAll(subProcessInNonBranchedNode);
        }
        Set<WFSearchResult> subProcesses = this.filterDuplicatedRecord(esProcessList);
        for (WFSearchResult subProcess : subProcesses) {
            WorkflowProcess proc = processList.stream().filter(x -> subProcess.getProcessId() == x.getId()).findAny().orElse(null);
            if (proc != null) {
                this.refillChildrenToken(subProcess.getToken(), proc.getRootToken());
            }
            result.addChild(subProcess);
        }
    }

    private Set<WFSearchResult> filterDuplicatedRecord(List<WFSearchResult> esProcessList) {
        LinkedHashSet subProcesses = Sets.newLinkedHashSet();
        Set idSet = Sets.newConcurrentHashSet();
        for (WFSearchResult wfSearchResult : esProcessList) {
            if (idSet.contains(wfSearchResult.getProcessId())) continue;
            subProcesses.add(wfSearchResult);
            idSet.add(wfSearchResult.getProcessId());
        }
        return subProcesses;
    }

    private List<WFSearchResult> fetchProcessinES(Set<Long> idSet) {
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)"id", idSet)).must((QueryBuilder)QueryBuilders.termQuery((String)"isActive", (boolean)true));
        bld.setPostFilter((QueryBuilder)filterBuilder);
        LOGGER.debug((Object)("Send request to ES \n" + bld.toString()));
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.client.getSettings().getReadTimeoutMs());
        return this.extractToResultList(resp);
    }

    private List<WFSearchResult> fetchSubProcessInES(long parentProcessId) {
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)"parentProcessId", (long)parentProcessId)).must((QueryBuilder)QueryBuilders.termQuery((String)"isActive", (boolean)true));
        bld.setPostFilter((QueryBuilder)filterBuilder);
        LOGGER.debug((Object)("Send request to ES \n" + bld.toString()));
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.client.getSettings().getReadTimeoutMs());
        return this.extractToResultList(resp);
    }

    private SearchParameterBase findField(List<SearchParameterBase> list, String fieldName) {
        return list.stream().filter(x -> StringUtils.equalsIgnoreCase((String)fieldName, (String)x.getFieldName())).findAny().orElse(null);
    }

    private long findParentProcessId(List<SearchParameterBase> whereList) {
        String processIdPredicate = null;
        for (SearchParameterBase param : whereList) {
            String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(param.getFieldName());
            if (!"id".equalsIgnoreCase(esPropertyName)) continue;
            processIdPredicate = param.getPredicate();
            processIdPredicate = processIdPredicate.substring(processIdPredicate.indexOf("= ") + 2);
            break;
        }
        return Configuration.toLong(processIdPredicate, (long)-1L);
    }

    /*
     * WARNING - void declaration
     */
    private List<WFSearchResult> expressSearchTopLevelProcesses(SearchCriteria searchCriteria, List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        void var9_22;
        boolean bl;
        Stopwatch topStopwatch = Stopwatch.createStarted();
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        for (SearchParameterBase searchParameterBase : sortList) {
            String string = WfsEsParameters.mapUIColumnToESProperty(searchParameterBase.getFieldName());
            FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)string);
            fieldSortBuilder.order(SortingOrder.DESCENDING.equals((Object)searchParameterBase.getSortingOrder()) ? SortOrder.DESC : SortOrder.ASC);
            fieldSortBuilder.ignoreUnmapped(true);
            bld.addSort((SortBuilder)fieldSortBuilder);
        }
        bld.setFrom(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            bld.setSize(searchCriteria.getRecordsCount());
        }
        LinkedList<TermQueryBuilder> filterBuilders = new LinkedList<TermQueryBuilder>();
        if (this.addActiveFilter(whereList)) {
            filterBuilders.add(QueryBuilders.termQuery((String)"isActive", (boolean)true));
        }
        for (SearchParameterBase searchParameterBase : whereList) {
            QueryBuilder queryBuilder = WFSElasticSearchFilterBuilder.getFilterBuilder(searchParameterBase);
            Optional.ofNullable(queryBuilder).ifPresent(filterBuilders::add);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : filterBuilders) {
            boolQueryBuilder.must(queryBuilder);
        }
        bld.setPostFilter((QueryBuilder)boolQueryBuilder);
        boolean bl2 = bl = searchCriteria.getStartingRecordNumber() + searchCriteria.getRecordsCount() > 10000;
        if (bl) {
            List<WFSearchResult> list = this.executeByScroll(searchCriteria, bld);
        } else {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOGGER.debug((Object)("Send search request to es :\n" + bld.toString()));
            LOGGER.debug((Object)("ES Request: " + bld.toString()));
            SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.client.getSettings().getReadTimeoutMs());
            LOGGER.debug((Object)("actionGet: " + Watch.cost((Stopwatch)stopwatch)));
            List<WFSearchResult> list = this.extractToResultList(resp);
        }
        LOGGER.debug((Object)("Total top level expressSearch: " + Watch.cost((Stopwatch)topStopwatch)));
        return var9_22;
    }

    private List<WFSearchResult> executeByScroll(SearchCriteria searchCriteria, SearchRequestBuilder bld) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        bld.setScroll(TimeValue.timeValueSeconds((long)30L));
        bld.setSearchType(SearchType.QUERY_THEN_FETCH);
        int startCursor = searchCriteria.getStartingRecordNumber();
        int scrollPageSize = 1000;
        int pageCount = startCursor / scrollPageSize;
        int startNumber = startCursor % scrollPageSize;
        int startPage = 0;
        if (pageCount == 0) {
            scrollPageSize = startNumber == 0 ? searchCriteria.getRecordsCount() : startNumber;
            startNumber = 0;
            pageCount = 1;
            startPage = 1;
        }
        LOGGER.debug((Object)("scrollPageSize : " + scrollPageSize + "  pageNumber: " + pageCount));
        bld.setSize(scrollPageSize);
        Stopwatch w = Stopwatch.createStarted();
        SearchResponse resp = this.createScroll(bld);
        String scrollId = resp.getScrollId();
        for (int i = startPage; i < pageCount; ++i) {
            resp = this.scrollQuery(scrollId);
        }
        LOGGER.debug((Object)("No of Shards:" + resp.getTotalShards() + " ScrollSize:" + scrollPageSize + " Hits:" + resp.getHits().hits().length));
        LOGGER.debug((Object)("Scoll Page " + pageCount + " in " + Watch.cost((Stopwatch)w)));
        if (StringUtils.isNotBlank((String)scrollId)) {
            this.client.getTransportClient().prepareClearScroll().addScrollId(scrollId).execute();
        }
        LOGGER.debug((Object)("Execute the scroll query in : " + Watch.cost((Stopwatch)stopwatch)));
        return this.extractToResultList(resp, startNumber, searchCriteria.getRecordsCount());
    }

    private SearchResponse createScroll(SearchRequestBuilder bld) {
        return (SearchResponse)bld.execute().actionGet(this.client.getSettings().getReadTimeoutMs());
    }

    private SearchResponse scrollQuery(String scrollId) {
        SearchScrollRequestBuilder build = this.client.getTransportClient().prepareSearchScroll(scrollId);
        build.setScroll(TimeValue.timeValueSeconds((long)30L));
        return (SearchResponse)build.get();
    }

    private List<WFSearchResult> extractToResultList(SearchResponse resp) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList processes = Lists.newArrayList();
        long totalHits = resp.getHits().totalHits();
        for (SearchHit hit : resp.getHits().hits()) {
            this.addToProcessList(processes, hit, totalHits);
        }
        LOGGER.debug((Object)("Object conversions: " + Watch.cost((Stopwatch)stopwatch)));
        return processes;
    }

    private List<WFSearchResult> extractToResultList(SearchResponse resp, int start, int size) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList processes = Lists.newArrayList();
        long totalHits = resp.getHits().totalHits();
        SearchHit[] hits = resp.getHits().hits();
        for (int i = start; i < hits.length && i - start < size; ++i) {
            this.addToProcessList(processes, hits[i], totalHits);
        }
        LOGGER.debug((Object)("Object conversions: " + Watch.cost((Stopwatch)stopwatch)));
        return processes;
    }

    private void addToProcessList(List<WFSearchResult> processes, SearchHit hit, long totalHits) {
        WFSearchResult process = this.esProcessHelper.convert(hit, totalHits);
        Optional.ofNullable(process).ifPresent(processes::add);
    }

    private boolean addActiveFilter(List<SearchParameterBase> parameters) {
        return this.findField(parameters, "all") == null;
    }

    @Override
    public int expressCount(SearchCriteria criteria) {
        List<WFSearchResult> result = this.expressSearch(criteria);
        WFSearchResult firstResult = (WFSearchResult)Iterables.getFirst(result, null);
        return firstResult == null ? 0 : (int)firstResult.getSearchResultCount();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof ProcessGUIPartialUpdateEvent) {
            WorkflowProcess process = ((ProcessGUIPartialUpdateEvent)event).getProcess();
            this.scheduler.schedule(() -> {
                this.partialUpdateForGUI(process);
                return null;
            });
            return;
        }
        if (event instanceof ProcessPersistEvent) {
            this.scheduler.schedule((Callable)new ProcessSaveCallable((ProcessPersistEvent)event));
        }
    }

    private void partialUpdateForGUI(WorkflowProcess process) {
        try {
            if (process == null || process.getId() < 1L || process.getRootToken() == null) {
                return;
            }
            String id = String.valueOf(process.getId());
            XContentBuilder builder = this.esProcessHelper.createGUIParitalUpdateBuilder(process);
            UpdateRequest updateRequest = new UpdateRequest("wfs", "processinstance", id);
            updateRequest.doc(builder);
            this.client.update(updateRequest).get(this.client.getSettings().getWriteTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error((Object)(process + ", failed to persist in ElasticSearch"), (Throwable)e);
        }
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    private BulkProcessor.Listener createListener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable e) {
                LOGGER.warn((Object)":(", e);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                LOGGER.debug((Object)("Bulk request took " + response.getTookInMillis() + "msec"));
                if (response.hasFailures()) {
                    LOGGER.warn((Object)response.buildFailureMessage());
                }
            }
        };
    }

    private class ProcessSaveCallable
    implements Callable<Void> {
        private ProcessPersistEvent event;

        ProcessSaveCallable(ProcessPersistEvent evt) {
            this.event = evt;
        }

        @Override
        public Void call() throws Exception {
            WorkflowProcess process = this.event.getProcess();
            if (!ProcessFinder.isOwner(process) && !this.event.isDeleted()) {
                return null;
            }
            try {
                if (this.event.isDeleted()) {
                    if (this.event.getProcess().isActive()) {
                        WFSElasticSearchService.this.delete(process.getId());
                    } else {
                        this.softDelete(process);
                    }
                } else {
                    WFSElasticSearchService.this.save(process);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)(process + ", failed to persist in ElasticSearch"), (Throwable)e);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void softDelete(WorkflowProcess process) throws IOException {
            if (process == null || process.getId() < 1L || process.getRootToken() == null) {
                return;
            }
            String procId = String.valueOf(process.getId());
            LOGGER.debug((Object)("Saving process[" + procId + "]"));
            try (XContentBuilder source = WFSElasticSearchService.this.esProcessHelper.createProcess(process);){
                WFSElasticSearchService.this.esProcessHelper.trySaving(procId, source, WFSElasticSearchService.this.client.getTransportClient());
            }
        }
    }
}

