/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class WfsEsParameters {
    public static final String INDEX_WFS = "wfs";
    public static final String TYPE_PROCESS_INSTANCE = "processinstance";
    public static final String ID = "id";
    public static final String HAS_CHILDREN = "hasChildren";
    public static final String HAS_FAILED_BRANCH = "hasFailedBranch";
    public static final String ROOT_TOKEN_ID = "rootTokenId";
    public static final String SUPER_PROCESS_TOKEN_ID = "superProcessTokenId";
    public static final String PROVIDER_ID = "providerId";
    public static final String TEMPLATE_ID = "templateId";
    public static final String TEMPLATE_NAME = "templateName";
    public static final String ADMIN_STATUS = "adminStatus";
    public static final String STATUS = "status";
    public static final String TITLE_ID = "titleId";
    public static final String TITLE_BRIEF = "titleBrief";
    public static final String LICENSE_START = "licenseStart";
    public static final String LICENSE_END = "licenseEnd";
    public static final String CURRENT_TASK = "currentTask";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String PRIORITY = "priority";
    public static final String NOTE = "note";
    public static final String CREATE_ID = "createId";
    public static final String ERROR_TIME = "errorTime";
    public static final String ERROR_COMMENT = "errorComment";
    public static final String ERROR_TYPE = "errorType";
    public static final String RECORD_TYPE_PROCESS = "process";
    public static final String RECORD_TYPE_TOKEN = "token";
    public static final String INGEST_TEMPLATE = "ingestTemplate";
    public static final String IS_ACTIVE = "isActive";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public List<String> fields;
    public String sortField;
    public boolean isAscSortOrder = true;
    public int pageSize;
    public int pageFrom;
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>();
    public static final String PARENT_PROCESS_ID = "parentProcessId";

    public static DateFormat getUTCFormat(String text, TimeZone timeZone) {
        String pattern = DATE_FORMAT;
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!text.matches(regexp)) continue;
            pattern = DATE_FORMAT_REGEXPS.get(regexp);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static String mapUIColumnToESProperty(String uiColumnName) {
        String esPropertyName = uiColumnName;
        if ("start".equalsIgnoreCase(uiColumnName)) {
            return START_TIME;
        }
        if ("hidesubprocess".equalsIgnoreCase(uiColumnName)) {
            return SUPER_PROCESS_TOKEN_ID;
        }
        if ("processdefinition.id".equalsIgnoreCase(uiColumnName)) {
            return TEMPLATE_ID;
        }
        if ("processdefinition.name".equalsIgnoreCase(uiColumnName)) {
            return TEMPLATE_NAME;
        }
        if (STATUS.equalsIgnoreCase(uiColumnName)) {
            return STATUS;
        }
        if ("title_Id".equalsIgnoreCase(uiColumnName)) {
            return TITLE_ID;
        }
        if (TITLE_ID.equalsIgnoreCase(uiColumnName)) {
            return TITLE_ID;
        }
        if ("rootToken.node.name".equalsIgnoreCase(uiColumnName)) {
            return CURRENT_TASK;
        }
        if ("licensingWindowStart".equalsIgnoreCase(uiColumnName)) {
            return LICENSE_START;
        }
        if ("licensingWindowEnd".equalsIgnoreCase(uiColumnName)) {
            return LICENSE_END;
        }
        if ("end".equalsIgnoreCase(uiColumnName)) {
            return END_TIME;
        }
        if ("requestedStatus".equalsIgnoreCase(uiColumnName)) {
            return ADMIN_STATUS;
        }
        if (PROVIDER_ID.equalsIgnoreCase(uiColumnName)) {
            return PROVIDER_ID;
        }
        if ("provider_id".equalsIgnoreCase(uiColumnName)) {
            return PROVIDER_ID;
        }
        return esPropertyName;
    }

    static {
        DATE_FORMAT_REGEXPS.put("^\\d{8}$", "yyyyMMdd");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
        DATE_FORMAT_REGEXPS.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
        DATE_FORMAT_REGEXPS.put("^\\d{12}$", "yyyyMMddHHmm");
        DATE_FORMAT_REGEXPS.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}$", "yyyy-MM-dd'T'HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
        DATE_FORMAT_REGEXPS.put("^\\d{14}$", "yyyyMMddHHmmss");
        DATE_FORMAT_REGEXPS.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}Z$", "yyyy-MM-dd HH:mm:ss'Z'");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{1,3}$", "yyyy-MM-dd HH:mm:ss.SSS");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{1,3}Z$", "yyyy-MM-dd HH:mm:ss.SSS'Z'");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd'T'HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}Z$", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}\\.\\d{1,3}$", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        DATE_FORMAT_REGEXPS.put("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}\\.\\d{1,3}Z$", DATE_FORMAT);
    }
}

