/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.scheduler.def.CreateTimerAction;

public class NodeTimeoutSetter
implements NodeVisitor {
    private static final Logger logger = Logger.getLogger(NodeTimeoutSetter.class);
    int index;
    Map<String, Object> timeouts;

    public NodeTimeoutSetter(Map<String, Object> timeouts) {
        this.timeouts = timeouts;
    }

    public void visit(Node node) {
        if (node == null || StringUtils.isBlank((String)this.getNodeTimeout(node))) {
            return;
        }
        Event event = null;
        if (node instanceof AbstractTaskNode) {
            event = node.getEvent("node-enter");
        } else if (node instanceof SuperState) {
            event = node.getEvent("superstate-enter");
        }
        if (event != null && event.hasActions()) {
            String timeout = this.getNodeTimeout(node);
            logger.debug((Object)(node.getName() + " timeout " + timeout));
            for (Object action : event.getActions()) {
                if (!(action instanceof CreateTimerAction)) continue;
                CreateTimerAction timer = (CreateTimerAction)CreateTimerAction.class.cast(action);
                timer.setDueDate(timeout);
            }
        }
    }

    private String getNodeTimeout(Node node) {
        return this.timeouts == null ? null : (String)this.timeouts.get(node.getName());
    }
}

