/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.google.common.base.Throwables;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.internal.ReplicatedSimpleCache;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.template.ITemplateCache;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class TemplateCache
extends ReplicatedSimpleCache<WorkflowTemplate>
implements ITemplateCache {
    private static final Logger LOGGER = Logger.getLogger(TemplateCache.class);

    public TemplateCache(Configuration config) {
        super(config.getString("template.cache.name"), config.getInteger("template.cache.size"));
    }

    public TemplateCache(String name, int size) {
        super(name, size);
    }

    private static String getServiceName(ResourceBundle bundle) {
        return bundle.getString("template.cache.name");
    }

    public static TemplateCache createTemplateCache() {
        ResourceBundle bundle = ResourceBundle.getBundle(TemplateCache.class.getPackage().getName() + ".service");
        Configuration configuration = Configuration.build((ResourceBundle)bundle);
        return new TemplateCache(configuration);
    }

    public static String getDefaultServiceName() {
        ResourceBundle bundle = ResourceBundle.getBundle(TemplateCache.class.getPackage().getName() + ".service");
        return TemplateCache.getServiceName(bundle);
    }

    @Override
    public void cache(WorkflowTemplate template, boolean notify) {
        LOGGER.debug((Object)("Adding to cache " + template));
        try {
            LOGGER.debug((Object)("Reloading template to local cache:  " + template.getId()));
            this.add(template.getId(), template, notify);
        }
        catch (StackOverflowError e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOGGER.error((Object)"Fail to add the template into cache:", rootCause);
            throw new TemplateReaderException("Fail to add the template into cache:", rootCause);
        }
    }

    @Override
    public void uncache(long templateId) {
        LOGGER.debug((Object)("Removing template from local cache: " + templateId));
        this.remove(templateId);
    }

    @Override
    public WorkflowTemplate get(long templateId) {
        return (WorkflowTemplate)super.get((Serializable)Long.valueOf(templateId));
    }
}

