/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.event;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import com.tandbergtv.workflow.driver.event.NodeTimeoutEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.message.TaskStatusEvent;
import com.tandbergtv.workflow.driver.event.message.TaskUpdateEvent;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.pluginmanager.event.ResourceGroupDescriptorChangeEvent;
import com.tandbergtv.workflow.pluginmanager.event.ResourceTypeDescriptorChangeEvent;
import com.tandbergtv.workflow.resourcemanager.LocalCacheNotReadyException;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.ResourceTypeContainer;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.event.AcquireResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ForwardedNodeTimeoutEvent;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupCachedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupSubscribeEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupUnsubscribeEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceOnlineEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceTypeCachedEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.entity.ResourceProxy;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorChangeHandler;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEventLogger;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class LocalEventHandler
extends ResourceManagementService
implements IEventHandler,
IResourceTypeIdAware {
    private static final Logger logger = Logger.getLogger(LocalEventHandler.class);
    private final ThreadLocal<Long> localResourceTypeId = new ThreadLocal();

    @Override
    public void handleEvent(WorkflowEvent event) {
        long start = System.currentTimeMillis();
        if (event instanceof AcquireResourceEvent) {
            this.handleAcquireResourceEvent((AcquireResourceEvent)event);
        } else if (event instanceof ReleaseResourceEvent) {
            this.handleReleaseResourceEvent((ReleaseResourceEvent)event);
        } else if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent processEvent = (WorkflowProcessEvent)event;
            WorkflowProcessEventType processEventType = processEvent.getType();
            switch (processEventType) {
                case PAUSED: {
                    this.handlePauseWorkOrderEvent(processEvent);
                    break;
                }
                case CANCELLED: {
                    this.handleCancelWorkOrderEvent(processEvent);
                    break;
                }
                case PRIORITY_CHANGED: {
                    this.handlePriorityChangedEvent(processEvent);
                    break;
                }
                case CRASHED: {
                    this.handleTokenCrashedEvent(processEvent);
                    break;
                }
                case FAILED: {
                    this.handleTokenFailedEvent(processEvent);
                    break;
                }
                case TIMEOUT: {
                    this.handleNodeTimeoutEvent((NodeTimeoutEvent)processEvent);
                    break;
                }
            }
        } else if (event instanceof TaskStatusEvent) {
            this.handleTaskStatusEvent((TaskStatusEvent)event);
        } else if (event instanceof PartitionEvent) {
            this.handlePartitionEvent((PartitionEvent)event);
        } else if (event instanceof ResourceTypeDescriptorChangeEvent) {
            this.handleResourceTypeDescriptorChangeEvent((ResourceTypeDescriptorChangeEvent)event);
        } else if (event instanceof ResourceGroupDescriptorChangeEvent) {
            this.handleResourceGroupDescriptorChangeEvent((ResourceGroupDescriptorChangeEvent)event);
        } else if (event instanceof ResourceHeartBeatEvent) {
            this.handleResourceHeartBeatEvent((ResourceHeartBeatEvent)event);
        } else if (event instanceof ResourceInitializationEvent) {
            this.handleResourceInitializationEvent((ResourceInitializationEvent)event);
        } else if (event instanceof ResourceTypeCachedEvent) {
            this.handleResourceTypeCachedEvent((ResourceTypeCachedEvent)event);
        } else if (event instanceof ResourceGroupCachedEvent) {
            this.handleResourceGroupCachedEvent((ResourceGroupCachedEvent)event);
        } else if (event instanceof ResourceOnlineEvent) {
            this.handleResourceOnlineEvent((ResourceOnlineEvent)event);
        } else if (event instanceof ResourceGroupSubscribeEvent) {
            this.handleResourceGroupSubscribeEvent((ResourceGroupSubscribeEvent)event);
        } else if (event instanceof ResourceGroupUnsubscribeEvent) {
            this.handleResourceGroupUnsubscribeEvent((ResourceGroupUnsubscribeEvent)event);
        }
        long duration = System.currentTimeMillis() - start;
        logger.debug((Object)("[RM-Events] " + event + " - localProcessing - " + duration + " ms."));
    }

    private void handleAcquireResourceEvent(AcquireResourceEvent event) {
        ResourceConsumerKey key = event.getResourceConsumerKey();
        Long resourceGroupId = key.getResourceGroupId();
        if (resourceGroupId == null) {
            logger.error((Object)("Received an Acquire Resource Event for Token " + key + " which is not mapped to a Resource Group."));
            this.getMediator().send((WorkflowEvent)new ResourceRequestRejectedEvent(key));
            return;
        }
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            logger.error((Object)("Received an Acquire Resource Event for Token " + key + " which is mapped to an invalid group."));
            this.getMediator().send((WorkflowEvent)new ResourceRequestRejectedEvent(key));
            return;
        }
        Set<ProtectionKey> protectionKeys = event.getProtectionKeys();
        this.getAllocationService().requestResourceAllocation(resourceGroupId, key, protectionKeys);
    }

    private void handleReleaseResourceEvent(ReleaseResourceEvent event) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            return;
        }
        this.getAllocationService().releaseToken((Token)event.getToken(), event.getResourceConsumerKey());
    }

    private void handlePauseWorkOrderEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    private void handleCancelWorkOrderEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    private void handleTokenFailedEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    private void handleTokenCrashedEvent(WorkflowProcessEvent event) {
        this.handleWorkOrderNotRunning(event);
    }

    private void handleWorkOrderNotRunning(WorkflowProcessEvent event) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            return;
        }
        Long resourceGroupId = event.getResourceGroupId();
        boolean dequeued = false;
        if (resourceGroupId != null) {
            dequeued = this.getAllocationService().dequeueToken(resourceGroupId, event.getToken());
        }
        if (!dequeued) {
            this.getAllocationService().releaseToken(event.getToken(), this.getResourceConsumerKey(event));
        }
    }

    private void handlePriorityChangedEvent(WorkflowProcessEvent event) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            return;
        }
        long tokenId = event.getToken().getId();
        ProcessPriority priority = event.getProcess().getPriority();
        Long resourceGroupId = event.getResourceGroupId();
        if (resourceGroupId == null) {
            return;
        }
        this.getAllocationService().repositionQueuedToken(resourceGroupId, tokenId, priority);
    }

    private void handleNodeTimeoutEvent(NodeTimeoutEvent event) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            return;
        }
        CustomToken token = (CustomToken)event.getToken();
        long tokenId = token.getId();
        ResourceContainer container = this.getLocatorService().findResource(tokenId);
        if (container == null) {
            Resource resource = this.getManager().getResourceByToken(tokenId);
            if (resource == null) {
                String name = token.getCurrentNode().getName();
                logger.warn((Object)("There is no resource associated with " + token + ", Node[" + name + "], ignoring the timeout event."));
                return;
            }
            String msg = "resource[" + resource.getId() + "] is not present in local cache.";
            throw new LocalCacheNotReadyException(msg);
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            Resource resource = (Resource)container.getEntity();
            if (!resource.getIgnoreTimeout()) {
                boolean stateChanged = this.getStateManager().failResource(container);
                if (stateChanged) {
                    container.updateEntity(true);
                    logger.info((Object)("[Resource] " + token + ", timeout has triggered Resource " + resource + " Error State."));
                }
                Resource clone = this.getCloneService().cloneResource(resource);
                this.getMediator().sendAsync((WorkflowEvent)new ResourceFailedEvent(token, clone));
            } else {
                Resource clone = this.getCloneService().cloneResource(resource);
                this.getMediator().sendAsync((WorkflowEvent)new ForwardedNodeTimeoutEvent(event, token, clone));
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private ResourceConsumerKey getResourceConsumerKey(WorkflowProcessEvent event) {
        return this.getResourceConsumerKey((CustomToken)event.getToken(), event.getResourceGroupId());
    }

    private ResourceConsumerKey getResourceConsumerKey(TaskStatusEvent event) {
        return this.getResourceConsumerKey((CustomToken)event.getToken(), event.getResourceGroupId());
    }

    private ResourceConsumerKey getResourceConsumerKey(CustomToken token, Long resourceGroupId) {
        WorkflowProcess process = token.getProcessInstance();
        return new ResourceConsumerKey(token.getId(), process.getId(), resourceGroupId, null, process.getPriority());
    }

    private void handleTaskStatusEvent(TaskStatusEvent event) {
        String eventName = this.getEventName(event);
        if (eventName == null) {
            return;
        }
        ResourceConsumerKey key = this.getResourceConsumerKey(event);
        Long resourceGroupId = event.getResourceGroupId();
        if (resourceGroupId == null) {
            return;
        }
        CustomToken token = (CustomToken)event.getToken();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            logger.error((Object)("Received a " + eventName + " for Token " + token + " which is mapped to an invalid group."));
            return;
        }
        IMessageUID uid = event.getMessage().getMessageUID();
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)resourceGroupId);
        String name = "resource group[" + resourceGroupId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        container.getReadLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            if (resourceGroup.isInternallyAcquired()) {
                logger.debug((Object)(token + " is not queued for the externally acquired resource group " + resourceGroup.getName() + ", ignoring " + uid));
                return;
            }
        }
        finally {
            container.getReadLock().unlock();
        }
        if (event.hasFailed()) {
            if (this.getAllocationService().dequeueToken(resourceGroupId, (Token)token)) {
                logger.warn((Object)(token + ", dequeued due to failure notification " + uid));
            }
        } else {
            String connectionString = DeviceTypeUtil.getConnectionString((IDevice)event.getExternalSource());
            String taskAssigner = event.getMessage().getCommand().getParameterValue("_task_assigner");
            boolean allocated = this.getAllocationService().performExternalAllocation(key, connectionString, taskAssigner);
            if (!allocated) {
                Resource resource = this.getManager().getResourceByConnectionString(connectionString);
                if (resource == null) {
                    logger.warn((Object)(token + ", rejecting external allocation of resource with connection string: " + connectionString + ", no such resource exists."));
                }
                this.getMediator().sendAsync((WorkflowEvent)new ResourceAllocationFailedEvent(token, resource, event.getMessage()));
            }
        }
    }

    private String getEventName(TaskStatusEvent event) {
        String eventName = null;
        if (event instanceof TaskUpdateEvent) {
            eventName = "Task Status Update Event";
        } else if (event instanceof TaskCompleteEvent) {
            eventName = "Task Complete Event";
        }
        return eventName;
    }

    private void handlePartitionEvent(PartitionEvent event) {
        if (!event.getSource().equals(this.getResourceTypeCache())) {
            return;
        }
        logger.debug((Object)"Received partition event for resource type cache.");
        if (event.isCompleted()) {
            for (Serializable key : event.getKeys()) {
                String type = "resource type[" + key + "]";
                try {
                    if (this.getResourceTypeContainerCache().get(key) != null) continue;
                    logger.debug((Object)("Starting local containers for " + type + " after migration."));
                    this.getContainerService().initializeContainers(key);
                    logger.info((Object)("Completed migration of " + type + "."));
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to migrate " + type + "."), (Throwable)e);
                }
            }
        } else {
            int partitionId = event.getPartitionId();
            ICacheService<ResourceTypeContainer> cache = this.getResourceTypeContainerCache();
            for (Serializable key : cache.getKeys()) {
                if (Cluster.getPartitionId((Object)key) != partitionId) continue;
                String type = "resource type[" + key + "]";
                try {
                    logger.debug((Object)("Stopping local containers for " + type + " for migration."));
                    this.getContainerService().shutdownContainers(key);
                    logger.info((Object)(String.valueOf(type) + " has migrated away."));
                }
                catch (Exception e) {
                    logger.error((Object)(String.valueOf(type) + " has failed to migrate away."), (Throwable)e);
                }
            }
        }
    }

    private void handleResourceTypeDescriptorChangeEvent(ResourceTypeDescriptorChangeEvent event) {
        this.getDescriptorChangeHandler().handleResourceTypeDescriptorChange(event.getDescriptor());
    }

    private void handleResourceGroupDescriptorChangeEvent(ResourceGroupDescriptorChangeEvent event) {
        this.getDescriptorChangeHandler().handleResourceGroupDescriptorChange(event.getDescriptor());
    }

    private void handleResourceInitializationEvent(ResourceInitializationEvent event) {
        if (event.getError() == null) {
            this.internallyHandleInitializationSuccess(event);
        } else {
            this.internallyHandleInitializationFailure(event);
        }
    }

    private void internallyHandleInitializationSuccess(ResourceInitializationEvent event) {
        long resourceId = event.getParentResource().getId();
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (container == null) {
            return;
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            boolean stateChanged = this.getStateManager().handleInitializationSuccess(container);
            if (stateChanged) {
                container.updateEntity(true);
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private void internallyHandleInitializationFailure(ResourceInitializationEvent event) {
        long resourceId = event.getParentResource().getId();
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (container == null) {
            return;
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            boolean stateChanged = this.getStateManager().handleInitializationFailure(container);
            if (stateChanged) {
                container.updateEntity(true);
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private void handleResourceHeartBeatEvent(ResourceHeartBeatEvent event) {
        if (event.getError() == null) {
            this.internallyHandleHeartBeatSuccess(event);
        } else {
            this.internallyHandleHeartBeatFailure(event);
        }
    }

    private void internallyHandleHeartBeatSuccess(ResourceHeartBeatEvent event) {
        long resourceId = event.getParentResource().getId();
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (container == null) {
            return;
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            boolean stateChanged = this.getStateManager().handleHeartBeatSuccess(container);
            if (stateChanged) {
                container.updateEntity(true);
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private void internallyHandleHeartBeatFailure(ResourceHeartBeatEvent event) {
        long resourceId = event.getParentResource().getId();
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (container == null) {
            return;
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            boolean stateChanged = this.getStateManager().handleHeartBeatFailure(container);
            if (stateChanged) {
                container.updateEntity(true);
            }
            if (((Resource)container.getEntity()).getUserCount() > 0) {
                Resource resource = (Resource)container.getEntity();
                Resource clone = this.getCloneService().cloneResource(resource);
                for (ResourceUser user : resource.getUsers()) {
                    ResourceConsumerKey key = user.getResourceConsumerKey();
                    logger.debug((Object)(key + " currently using Resource[" + resource.getId() + "]: " + resource.getName() + " is being notified about a received heartbeat failure."));
                    this.getMediator().sendAsync((WorkflowEvent)new ResourceFailedEvent(key, clone));
                }
            }
        }
        finally {
            container.getWriteLock().unlock();
            ResourceHeartBeatEventLogger heartBeatLogger = new ResourceHeartBeatEventLogger();
            heartBeatLogger.logEvent(event);
        }
    }

    private void handleResourceTypeCachedEvent(ResourceTypeCachedEvent event) {
        long resourceTypeId = event.getResourceTypeId();
        ResourceType resourceType = (ResourceType)this.getResourceTypeCache().get((Serializable)Long.valueOf(resourceTypeId));
        if (resourceType != null) {
            IContainerService service = this.getContainerService();
            ResourceTypeContainer container = service.createResourceTypeContainer(resourceType);
            logger.info((Object)("Started processing for new " + container));
        } else {
            logger.error((Object)("Failed to find resource type[" + resourceTypeId + "] in distributed cache, cannot create container for local cache."));
        }
    }

    private void handleResourceGroupCachedEvent(ResourceGroupCachedEvent event) {
        long resourceTypeId = event.getResourceTypeId();
        long resourceGroupId = event.getResourceGroupId();
        ResourceGroup group = null;
        Collection groups = this.getResourceGroupCache().get((Serializable)Long.valueOf(event.getResourceTypeId()));
        if (groups != null) {
            for (ResourceGroup resourceGroup : groups) {
                if (resourceGroup.getId() != resourceGroupId) continue;
                group = resourceGroup;
                break;
            }
        }
        if (group != null) {
            this.getLocatorService().setResourceTypeIdForGroup(group.getId(), resourceTypeId);
            IContainerService service = this.getContainerService();
            ResourceTypeContainer typeContainer = (ResourceTypeContainer)this.getResourceTypeContainerCache().get((Serializable)Long.valueOf(resourceTypeId));
            String typeName = "resource type[" + resourceTypeId + "]";
            service.verifyContainerReady(typeName, typeContainer);
            typeContainer.getReadLock().lock();
            try {
                service.verifyContainerReady(typeContainer);
                ResourceGroupContainer container = service.createResourceGroupContainer(group);
                logger.info((Object)("Started processing for new " + container));
            }
            finally {
                typeContainer.getReadLock().unlock();
            }
        } else {
            logger.error((Object)("Failed to find resource group[" + resourceGroupId + "] in distributed cache, cannot create container for local cache."));
        }
    }

    private void handleResourceOnlineEvent(ResourceOnlineEvent event) {
        this.getAllocationService().notifyQueues(event.getResourceId());
    }

    private void handleResourceGroupSubscribeEvent(ResourceGroupSubscribeEvent event) {
        long resourceGroupId = event.getResourceGroupId();
        long resourceId = event.getResourceId();
        this.updateResourceGroupMembership(resourceGroupId, resourceId, true);
    }

    private void handleResourceGroupUnsubscribeEvent(ResourceGroupUnsubscribeEvent event) {
        long resourceGroupId = event.getResourceGroupId();
        long resourceId = event.getResourceId();
        this.updateResourceGroupMembership(resourceGroupId, resourceId, false);
    }

    private void updateResourceGroupMembership(long resourceGroupId, long resourceId, boolean add) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null) {
            return;
        }
        boolean notifyQueue = false;
        String groupName = "resource group[" + resourceGroupId + "]";
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(groupName, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup group = (ResourceGroup)container.getEntity();
            ResourceProxy resource = new ResourceProxy(resourceId);
            if (add && group.getResources().contains(resource)) {
                return;
            }
            if (!add && !group.getResources().contains(resource)) {
                return;
            }
            ResourceContainer resourceContainer = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
            if (this.updateResourceGroupMembership(resourceContainer, group, resource, add)) {
                container.updateEntity();
                return;
            }
            resourceContainer.getReadLock().lock();
            try {
                if (this.updateResourceGroupMembership(resourceContainer, group, resource, add)) {
                    container.updateEntity();
                    return;
                }
                Resource cachedResource = (Resource)resourceContainer.getEntity();
                if (add && cachedResource.getResourceGroups().contains(group)) {
                    group.addResource(resource);
                    container.updateEntity();
                    notifyQueue = true;
                } else if (!add && !cachedResource.getResourceGroups().contains(group)) {
                    group.removeResource(resource);
                    container.updateEntity();
                }
            }
            finally {
                resourceContainer.getReadLock().unlock();
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        if (notifyQueue) {
            container.notifyQueue();
        }
    }

    private boolean updateResourceGroupMembership(ResourceContainer container, ResourceGroup resourceGroup, Resource resource, boolean add) {
        if ((container == null || container.isStopped()) && !this.getManager().isResourceActive(resource.getId())) {
            if (!add) {
                resourceGroup.removeResource(resource);
            }
            return true;
        }
        String name = "resource[" + resource.getId() + "]";
        this.getContainerService().verifyContainerReady(name, container);
        return false;
    }

    private Long getResourceTypeIdForRequest() {
        return this.localResourceTypeId.get();
    }

    @Override
    public void setResourceTypeIdForRequest(Long resourceTypeId) {
        this.localResourceTypeId.set(resourceTypeId);
    }

    @Override
    public void removeResourceTypeIdForRequest() {
        this.localResourceTypeId.remove();
    }

    @Override
    public String getServiceName() {
        return "ResourceManagementLocalEventHandler";
    }

    private ResourceManagement getManager() {
        return (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
    }

    private IMediator getMediator() {
        return DefaultMediator.getInstance();
    }

    private ICacheService<ResourceType> getResourceTypeCache() {
        return (ICacheService)this.getService("WFS:ResourceTypeCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroupCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private ICacheService<ResourceTypeContainer> getResourceTypeContainerCache() {
        return (ICacheService)this.getService("ResourceTypeContainerCache");
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainerCache() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private ICacheService<ResourceContainer> getResourceContainerCache() {
        return (ICacheService)this.getService("ResourceContainerCache");
    }

    private IResourceAllocationService getAllocationService() {
        return this.getService(IResourceAllocationService.class);
    }

    private ResourceStateManager getStateManager() {
        return this.getService(ResourceStateManager.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private IPluginDescriptorChangeHandler getDescriptorChangeHandler() {
        return this.getService(IPluginDescriptorChangeHandler.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private IContainerService getContainerService() {
        return this.getService(IContainerService.class);
    }
}

