/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.google.common.base.Stopwatch;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.MultiMap;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DistributedMultiValueCache<T>
implements IMultiValueCacheService<T> {
    protected String name;
    protected int size;
    protected MultiMap<Serializable, T> map;
    private IClusterService clusterService;
    private static final Logger LOGGER = Logger.getLogger(DistributedMultiValueCache.class);

    public DistributedMultiValueCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public DistributedMultiValueCache(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
        MapConfig config = new MapConfig(this.name);
        config.getMaxSizeConfig().setSize(this.size);
        config.setEvictionPolicy(EvictionPolicy.LRU);
        this.getClusterService().getInstance().getConfig().addMapConfig(config);
        this.map = this.getClusterService().getInstance().getMultiMap(this.name);
    }

    @Override
    public void stop() {
        this.map = null;
    }

    @Override
    public Collection<T> get(Serializable key) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Collection cachedValues = this.map.get((Object)key);
        if (cachedValues == null) {
            return Collections.emptySet();
        }
        HashSet filteredValues = new HashSet();
        for (Object value : cachedValues) {
            if (filteredValues.contains(value)) {
                filteredValues.remove(value);
            }
            filteredValues.add(value);
        }
        LOGGER.debug((Object)(" get Values by [" + key + "] from " + this.getServiceName() + " cache in " + this.cost(stopwatch)));
        return filteredValues;
    }

    @Override
    public Set<Serializable> getKeys() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> getValues() {
        return this.map.values();
    }

    @Override
    public boolean add(Serializable key, T value) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        T oldValue = this.findEqualValue(key, value);
        boolean result = this.map.put((Object)key, value);
        if (result && oldValue != null) {
            this.removeExistingValue(key, oldValue);
        }
        boolean flag = result || oldValue != null;
        LOGGER.debug((Object)(" add  Object by [" + key + "] into " + this.getServiceName() + " cache in " + this.cost(stopwatch)));
        return flag;
    }

    private String cost(Stopwatch stopwatch) {
        return stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms.";
    }

    @Override
    public boolean remove(Serializable key, T value) {
        T oldValue = this.findEqualValue(key, value);
        if (oldValue != null) {
            return this.removeExistingValue(key, oldValue);
        }
        return false;
    }

    protected T findEqualValue(Serializable key, T value) {
        Collection values = this.map.get((Object)key);
        if (values != null) {
            for (Object oldValue : values) {
                if (!oldValue.equals(value)) continue;
                return (T)oldValue;
            }
        }
        return null;
    }

    private boolean removeExistingValue(Serializable key, T existingValue) {
        boolean removed = this.map.remove((Object)key, existingValue);
        if (!removed) {
            LOGGER.warn((Object)("Multi-Value Cache[" + this.getServiceName() + "]: Failed to remove existing value " + existingValue), new Throwable());
        }
        return removed;
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    @Override
    public Collection<T> remove(Serializable key) {
        return this.map.remove((Object)key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public int valueCount(Serializable key) {
        return this.map.valueCount((Object)key);
    }

    @Override
    public boolean containsKey(Serializable key) {
        return this.map.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(T value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsEntry(Serializable key, T value) {
        return this.map.containsEntry((Object)key, value);
    }
}

