/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.util.CloseableThreadLocal;

public class XStringField
extends Field {
    private static final CloseableThreadLocal<Field.StringTokenStream> NOT_ANALYZED_TOKENSTREAM = new CloseableThreadLocal<Field.StringTokenStream>(){

        protected Field.StringTokenStream initialValue() {
            return new Field.StringTokenStream();
        }
    };

    public XStringField(String name, String value, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = value;
    }

    public TokenStream tokenStream(Analyzer analyzer) throws IOException {
        if (!this.fieldType().indexed()) {
            return null;
        }
        if (this.fieldType().tokenized()) {
            return super.tokenStream(analyzer);
        }
        Field.StringTokenStream nonAnalyzedTokenStream = (Field.StringTokenStream)NOT_ANALYZED_TOKENSTREAM.get();
        nonAnalyzedTokenStream.setValue((String)this.fieldsData);
        return nonAnalyzedTokenStream;
    }
}

