/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadOperationAction<ClusterHealthRequest, ClusterHealthResponse> {
    private final ClusterName clusterName;

    @Inject
    public TransportClusterHealthAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName) {
        super(settings, transportService, clusterService, threadPool);
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "cluster/health";
    }

    @Override
    protected ClusterHealthRequest newRequest() {
        return new ClusterHealthRequest();
    }

    @Override
    protected ClusterHealthResponse newResponse() {
        return new ClusterHealthResponse();
    }

    @Override
    protected void masterOperation(ClusterHealthRequest request, ClusterState unusedState, ActionListener<ClusterHealthResponse> listener) throws ElasticsearchException {
        long endTime = System.currentTimeMillis() + request.timeout().millis();
        if (request.waitForEvents() != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", request.waitForEvents(), new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    latch.countDown();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    TransportClusterHealthAction.this.logger.error("unexpected failure during [{}]", t, source);
                }
            });
            try {
                latch.await(request.timeout().millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int waitFor = 5;
        if (request.waitForStatus() == null) {
            --waitFor;
        }
        if (request.waitForRelocatingShards() == -1) {
            --waitFor;
        }
        if (request.waitForActiveShards() == -1) {
            --waitFor;
        }
        if (request.waitForNodes().isEmpty()) {
            --waitFor;
        }
        if (request.indices().length == 0) {
            --waitFor;
        }
        if (waitFor == 0) {
            ClusterState clusterState = this.clusterService.state();
            listener.onResponse(this.clusterHealth(request, clusterState));
            return;
        }
        while (true) {
            int waitForCounter = 0;
            ClusterState clusterState = this.clusterService.state();
            ClusterHealthResponse response = this.clusterHealth(request, clusterState);
            if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
                ++waitForCounter;
            }
            if (request.waitForRelocatingShards() != -1 && response.getRelocatingShards() <= request.waitForRelocatingShards()) {
                ++waitForCounter;
            }
            if (request.waitForActiveShards() != -1 && response.getActiveShards() >= request.waitForActiveShards()) {
                ++waitForCounter;
            }
            if (request.indices().length > 0) {
                try {
                    clusterState.metaData().concreteIndices(IndicesOptions.strictExpand(), request.indices());
                    ++waitForCounter;
                }
                catch (IndexMissingException e) {
                    response.status = ClusterHealthStatus.RED;
                }
            }
            if (!request.waitForNodes().isEmpty()) {
                if (request.waitForNodes().startsWith(">=")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(2));
                    if (response.getNumberOfNodes() >= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("ge(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.getNumberOfNodes() >= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("<=")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(2));
                    if (response.getNumberOfNodes() <= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("le(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.getNumberOfNodes() <= expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith(">")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(1));
                    if (response.getNumberOfNodes() > expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("gt(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.getNumberOfNodes() > expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("<")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(1));
                    if (response.getNumberOfNodes() < expected) {
                        ++waitForCounter;
                    }
                } else if (request.waitForNodes().startsWith("lt(")) {
                    int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                    if (response.getNumberOfNodes() < expected) {
                        ++waitForCounter;
                    }
                } else {
                    int expected = Integer.parseInt(request.waitForNodes());
                    if (response.getNumberOfNodes() == expected) {
                        ++waitForCounter;
                    }
                }
            }
            if (waitForCounter == waitFor) {
                listener.onResponse(response);
                return;
            }
            if (System.currentTimeMillis() > endTime) {
                response.timedOut = true;
                listener.onResponse(response);
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                response.timedOut = true;
                listener.onResponse(response);
                return;
            }
        }
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState) {
        String[] concreteIndices;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Calculating health based on state version [{}]", clusterState.version());
        }
        try {
            concreteIndices = clusterState.metaData().concreteIndices(IndicesOptions.lenientExpandOpen(), request.indices());
        }
        catch (IndexMissingException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(this.clusterName.value(), Strings.EMPTY_ARRAY, clusterState);
            response.status = ClusterHealthStatus.RED;
            return response;
        }
        return new ClusterHealthResponse(this.clusterName.value(), concreteIndices, clusterState);
    }
}

