/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterRerouteAction
extends TransportMasterNodeOperationAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private final AllocationService allocationService;

    @Inject
    public TransportClusterRerouteAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService) {
        super(settings, transportService, clusterService, threadPool);
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "cluster/reroute";
    }

    @Override
    protected ClusterRerouteRequest newRequest() {
        return new ClusterRerouteRequest();
    }

    @Override
    protected ClusterRerouteResponse newResponse() {
        return new ClusterRerouteResponse();
    }

    @Override
    protected void masterOperation(final ClusterRerouteRequest request, ClusterState state, final ActionListener<ClusterRerouteResponse> listener) throws ElasticsearchException {
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", Priority.IMMEDIATE, new AckedClusterStateUpdateTask(){
            private volatile ClusterState clusterStateToSend;
            private volatile RoutingExplanations explanations;

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new ClusterRerouteResponse(true, this.clusterStateToSend, this.explanations));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.timeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportClusterRerouteAction.this.logger.debug("failed to perform [{}]", t, source);
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState newState;
                RoutingAllocation.Result routingResult = TransportClusterRerouteAction.this.allocationService.reroute(currentState, request.commands, request.explain());
                this.clusterStateToSend = newState = ClusterState.builder(currentState).routingResult(routingResult).build();
                this.explanations = routingResult.explanations();
                if (request.dryRun) {
                    return currentState;
                }
                return newState;
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }
}

