/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class RestoreSnapshotRequest
extends MasterNodeOperationRequest<RestoreSnapshotRequest> {
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String renamePattern;
    private String renameReplacement;
    private boolean waitForCompletion;
    private boolean includeGlobalState = true;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;

    RestoreSnapshotRequest() {
    }

    public RestoreSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices are missing", validationException);
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is missing", validationException);
        }
        if (this.settings == null) {
            validationException = ValidateActions.addValidationError("settings are missing", validationException);
        }
        return validationException;
    }

    public RestoreSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public RestoreSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public RestoreSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public RestoreSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public RestoreSnapshotRequest renamePattern(String renamePattern) {
        this.renamePattern = renamePattern;
        return this;
    }

    public String renamePattern() {
        return this.renamePattern;
    }

    public RestoreSnapshotRequest renameReplacement(String renameReplacement) {
        this.renameReplacement = renameReplacement;
        return this;
    }

    public String renameReplacement() {
        return this.renameReplacement;
    }

    public RestoreSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public RestoreSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public RestoreSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest settings(String source) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public RestoreSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public RestoreSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public RestoreSnapshotRequest source(XContentBuilder source) {
        try {
            return this.source(source.bytes());
        }
        catch (Exception e) {
            throw new ElasticsearchIllegalArgumentException("Failed to build json for repository request", e);
        }
    }

    public RestoreSnapshotRequest source(Map source) {
        boolean ignoreUnavailable = IndicesOptions.lenientExpandOpen().ignoreUnavailable();
        boolean allowNoIndices = IndicesOptions.lenientExpandOpen().allowNoIndices();
        boolean expandWildcardsOpen = IndicesOptions.lenientExpandOpen().expandWildcardsOpen();
        boolean expandWildcardsClosed = IndicesOptions.lenientExpandOpen().expandWildcardsClosed();
        for (Map.Entry entry : source.entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("ignore_unavailable") || name.equals("ignoreUnavailable")) {
                ignoreUnavailable = XContentMapValues.nodeBooleanValue(entry.getValue());
                continue;
            }
            if (name.equals("allow_no_indices") || name.equals("allowNoIndices")) {
                allowNoIndices = XContentMapValues.nodeBooleanValue(entry.getValue());
                continue;
            }
            if (name.equals("expand_wildcards_open") || name.equals("expandWildcardsOpen")) {
                expandWildcardsOpen = XContentMapValues.nodeBooleanValue(entry.getValue());
                continue;
            }
            if (name.equals("expand_wildcards_closed") || name.equals("expandWildcardsClosed")) {
                expandWildcardsClosed = XContentMapValues.nodeBooleanValue(entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new ElasticsearchIllegalArgumentException("malformed settings section, should indices an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("include_global_state")) {
                this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue());
                continue;
            }
            if (name.equals("rename_pattern")) {
                if (entry.getValue() instanceof String) {
                    this.renamePattern((String)entry.getValue());
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("malformed rename_pattern");
            }
            if (name.equals("rename_replacement")) {
                if (entry.getValue() instanceof String) {
                    this.renameReplacement((String)entry.getValue());
                    continue;
                }
                throw new ElasticsearchIllegalArgumentException("malformed rename_replacement");
            }
            throw new ElasticsearchIllegalArgumentException("Unknown parameter " + name);
        }
        this.indicesOptions(IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandWildcardsOpen, expandWildcardsClosed));
        return this;
    }

    public RestoreSnapshotRequest source(String source) {
        if (Strings.hasLength(source)) {
            try {
                return this.source(XContentFactory.xContent(source).createParser(source).mapOrderedAndClose());
            }
            catch (Exception e) {
                throw new ElasticsearchIllegalArgumentException("failed to parse repository source [" + source + "]", e);
            }
        }
        return this;
    }

    public RestoreSnapshotRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public RestoreSnapshotRequest source(byte[] source, int offset, int length) {
        if (length > 0) {
            try {
                return this.source(XContentFactory.xContent(source, offset, length).createParser(source, offset, length).mapOrderedAndClose());
            }
            catch (IOException e) {
                throw new ElasticsearchIllegalArgumentException("failed to parse repository source", e);
            }
        }
        return this;
    }

    public RestoreSnapshotRequest source(BytesReference source) {
        try {
            return this.source(XContentFactory.xContent(source).createParser(source).mapOrderedAndClose());
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalArgumentException("failed to parse template source", e);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.renamePattern = in.readOptionalString();
        this.renameReplacement = in.readOptionalString();
        this.waitForCompletion = in.readBoolean();
        this.includeGlobalState = in.readBoolean();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.renamePattern);
        out.writeOptionalString(this.renameReplacement);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.includeGlobalState);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
    }
}

