/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportMasterNodeReadOperationAction<ClusterStateRequest, ClusterStateResponse> {
    private final ClusterName clusterName;

    @Inject
    public TransportClusterStateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName) {
        super(settings, transportService, clusterService, threadPool);
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "cluster/state";
    }

    @Override
    protected ClusterStateRequest newRequest() {
        return new ClusterStateRequest();
    }

    @Override
    protected ClusterStateResponse newResponse() {
        return new ClusterStateResponse();
    }

    @Override
    protected void masterOperation(ClusterStateRequest request, ClusterState state, ActionListener<ClusterStateResponse> listener) throws ElasticsearchException {
        ClusterState currentState = this.clusterService.state();
        this.logger.trace("Serving cluster state request using version {}", currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : request.indices()) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder);
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        if (request.metaData()) {
            MetaData.Builder mdBuilder = request.indices().length == 0 ? MetaData.builder(currentState.metaData()) : MetaData.builder();
            if (request.indices().length > 0) {
                String[] indices;
                for (String filteredIndex : indices = currentState.metaData().concreteIndices(IndicesOptions.lenientExpandOpen(), request.indices())) {
                    IndexMetaData indexMetaData = currentState.metaData().index(filteredIndex);
                    if (indexMetaData == null) continue;
                    mdBuilder.put(indexMetaData, false);
                }
            }
            builder.metaData(mdBuilder);
        }
        listener.onResponse(new ClusterStateResponse(this.clusterName, builder.build()));
    }
}

