/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.BytesBinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DisabledIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FSTBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FloatArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointBinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.IndexIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PackedArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;

public class IndexFieldDataService
extends AbstractIndexComponent {
    private static final String DISABLED_FORMAT = "disabled";
    private static final String DOC_VALUES_FORMAT = "doc_values";
    private static final String ARRAY_FORMAT = "array";
    private static final String PAGED_BYTES_FORMAT = "paged_bytes";
    private static final String FST_FORMAT = "fst";
    private static final String COMPRESSED_FORMAT = "compressed";
    private static final ImmutableMap<String, IndexFieldData.Builder> buildersByType = MapBuilder.newMapBuilder().put("string", new PagedBytesIndexFieldData.Builder()).put("float", (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put("double", (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put("byte", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put("short", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put("int", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put("long", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put("geo_point", (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).put("_parent", (PagedBytesIndexFieldData.Builder)((Object)new ParentChildIndexFieldData.Builder())).put("_index", (PagedBytesIndexFieldData.Builder)((Object)new IndexIndexFieldData.Builder())).put("binary", (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).immutableMap();
    private static final ImmutableMap<String, IndexFieldData.Builder> docValuesBuildersByType = MapBuilder.newMapBuilder().put("string", new DocValuesIndexFieldData.Builder()).put("float", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT)).put("double", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE)).put("byte", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE)).put("short", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT)).put("int", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT)).put("long", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG)).put("geo_point", (DocValuesIndexFieldData.Builder)((Object)new GeoPointBinaryDVIndexFieldData.Builder())).put("binary", (DocValuesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).immutableMap();
    private static final ImmutableMap<Tuple<String, String>, IndexFieldData.Builder> buildersByTypeAndFormat = MapBuilder.newMapBuilder().put(Tuple.tuple("string", "paged_bytes"), new PagedBytesIndexFieldData.Builder()).put(Tuple.tuple("string", "fst"), (PagedBytesIndexFieldData.Builder)((Object)new FSTBytesIndexFieldData.Builder())).put(Tuple.tuple("string", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder())).put(Tuple.tuple("string", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("float", "array"), (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put(Tuple.tuple("float", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT))).put(Tuple.tuple("float", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("double", "array"), (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("double", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE))).put(Tuple.tuple("double", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("byte", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("short", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("int", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("long", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "array"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointBinaryDVIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "compressed"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointCompressedIndexFieldData.Builder())).put(Tuple.tuple("binary", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).put(Tuple.tuple("binary", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).immutableMap();
    private final CircuitBreakerService circuitBreakerService;
    private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final ConcurrentMap<String, IndexFieldData<?>> loadedFieldData = ConcurrentCollections.newConcurrentMap();
    private final Map<String, IndexFieldDataCache> fieldDataCaches = Maps.newHashMap();
    IndexService indexService;

    public IndexFieldDataService(Index index, CircuitBreakerService circuitBreakerService) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, new IndicesFieldDataCache(ImmutableSettings.Builder.EMPTY_SETTINGS, new IndicesFieldDataCacheListener(circuitBreakerService)), circuitBreakerService, new IndicesFieldDataCacheListener(circuitBreakerService));
    }

    public IndexFieldDataService(Index index, CircuitBreakerService circuitBreakerService, IndicesFieldDataCache indicesFieldDataCache) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, indicesFieldDataCache, circuitBreakerService, new IndicesFieldDataCacheListener(circuitBreakerService));
    }

    @Inject
    public IndexFieldDataService(Index index, @IndexSettings Settings indexSettings, IndicesFieldDataCache indicesFieldDataCache, CircuitBreakerService circuitBreakerService, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
        super(index, indexSettings);
        this.indicesFieldDataCache = indicesFieldDataCache;
        this.circuitBreakerService = circuitBreakerService;
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
    }

    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            for (IndexFieldData fieldData : this.loadedFieldData.values()) {
                fieldData.clear();
            }
            this.loadedFieldData.clear();
            for (IndexFieldDataCache cache : this.fieldDataCaches.values()) {
                cache.clear();
            }
            this.fieldDataCaches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearField(String fieldName) {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            IndexFieldDataCache cache;
            IndexFieldData fieldData = (IndexFieldData)this.loadedFieldData.remove(fieldName);
            if (fieldData != null) {
                fieldData.clear();
            }
            if ((cache = this.fieldDataCaches.remove(fieldName)) != null) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IndexReader reader) {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            for (IndexFieldData indexFieldData : this.loadedFieldData.values()) {
                indexFieldData.clear(reader);
            }
            for (IndexFieldDataCache cache : this.fieldDataCaches.values()) {
                cache.clear(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMappingUpdate() {
        ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
        synchronized (concurrentMap) {
            this.loadedFieldData.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IFD extends IndexFieldData<?>> IFD getForField(FieldMapper<?> mapper) {
        FieldMapper.Names fieldNames = mapper.names();
        FieldDataType type = mapper.fieldDataType();
        if (type == null) {
            throw new ElasticsearchIllegalArgumentException("found no fielddata type for field [" + fieldNames.fullName() + "]");
        }
        boolean docValues = mapper.hasDocValues();
        IndexFieldData fieldData = (IndexFieldData)this.loadedFieldData.get(fieldNames.indexName());
        if (fieldData == null) {
            ConcurrentMap<String, IndexFieldData<?>> concurrentMap = this.loadedFieldData;
            synchronized (concurrentMap) {
                fieldData = (IndexFieldData)this.loadedFieldData.get(fieldNames.indexName());
                if (fieldData == null) {
                    IndexFieldData.Builder builder = null;
                    String format = type.getFormat(this.indexSettings);
                    if (format != null && DOC_VALUES_FORMAT.equals(format) && !docValues) {
                        this.logger.warn("field [" + fieldNames.fullName() + "] has no doc values, will use default field data format", new Object[0]);
                        format = null;
                    }
                    if (format != null && (builder = buildersByTypeAndFormat.get(Tuple.tuple(type.getType(), format))) == null) {
                        this.logger.warn("failed to find format [" + format + "] for field [" + fieldNames.fullName() + "], will use default", new Object[0]);
                    }
                    if (builder == null && docValues) {
                        builder = docValuesBuildersByType.get(type.getType());
                    }
                    if (builder == null) {
                        builder = buildersByType.get(type.getType());
                    }
                    if (builder == null) {
                        throw new ElasticsearchIllegalArgumentException("failed to find field data builder for field " + fieldNames.fullName() + ", and type " + type.getType());
                    }
                    IndexFieldDataCache cache = this.fieldDataCaches.get(fieldNames.indexName());
                    if (cache == null) {
                        String cacheType = type.getSettings().get("cache", this.indexSettings.get("index.fielddata.cache", "node"));
                        if ("resident".equals(cacheType)) {
                            cache = new IndexFieldDataCache.Resident(this.logger, this.indexService, fieldNames, type, this.indicesFieldDataCacheListener);
                        } else if ("soft".equals(cacheType)) {
                            cache = new IndexFieldDataCache.Soft(this.logger, this.indexService, fieldNames, type, this.indicesFieldDataCacheListener);
                        } else if ("node".equals(cacheType)) {
                            cache = this.indicesFieldDataCache.buildIndexFieldDataCache(this.indexService, this.index, fieldNames, type);
                        } else {
                            throw new ElasticsearchIllegalArgumentException("cache type not supported [" + cacheType + "] for field [" + fieldNames.fullName() + "]");
                        }
                        this.fieldDataCaches.put(fieldNames.indexName(), cache);
                    }
                    InternalGlobalOrdinalsBuilder globalOrdinalBuilder = new InternalGlobalOrdinalsBuilder(this.index(), this.indexSettings);
                    fieldData = builder.build(this.index, this.indexSettings, mapper, cache, this.circuitBreakerService, this.indexService.mapperService(), globalOrdinalBuilder);
                    this.loadedFieldData.put(fieldNames.indexName(), fieldData);
                }
            }
        }
        return (IFD)fieldData;
    }
}

