/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.search.MultiValueMode;

public class GeoDistanceComparator
extends NumberComparatorBase<Double> {
    protected final IndexGeoPointFieldData<?> indexFieldData;
    protected final double lat;
    protected final double lon;
    protected final DistanceUnit unit;
    protected final GeoDistance geoDistance;
    protected final GeoDistance.FixedSourceDistance fixedSourceDistance;
    protected final MultiValueMode sortMode;
    private static final Double MISSING_VALUE = Double.MAX_VALUE;
    private final double[] values;
    private double bottom;
    private GeoDistanceValues geoDistanceValues;

    public GeoDistanceComparator(int numHits, IndexGeoPointFieldData<?> indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, MultiValueMode sortMode) {
        this.values = new double[numHits];
        this.indexFieldData = indexFieldData;
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.geoDistance = geoDistance;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, unit);
        this.sortMode = sortMode;
    }

    public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
        GeoPointValues readerValues = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        this.geoDistanceValues = readerValues.isMultiValued() ? new MV(readerValues, this.fixedSourceDistance, this.sortMode) : new SV(readerValues, this.fixedSourceDistance);
        return this;
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    public int compareBottom(int doc) {
        double v2 = this.geoDistanceValues.computeDistance(doc);
        return Double.compare(this.bottom, v2);
    }

    public int compareTop(int doc) throws IOException {
        double docValue = this.geoDistanceValues.computeDistance(doc);
        return Double.compare((Double)this.top, docValue);
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.geoDistanceValues.computeDistance(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + this.geoDistanceValues.computeDistance(doc);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (double)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = MISSING_VALUE;
    }

    @Override
    public int compareBottomMissing() {
        return Double.compare(this.bottom, MISSING_VALUE);
    }

    @Override
    public int compareTopMissing() {
        return Double.compare((Double)this.top, MISSING_VALUE);
    }

    private static final class MV
    extends GeoDistanceValues {
        private final MultiValueMode sortMode;

        MV(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance, MultiValueMode sortMode) {
            super(readerValues, fixedSourceDistance);
            this.sortMode = sortMode;
        }

        @Override
        public double computeDistance(int doc) {
            int length = this.readerValues.setDocument(doc);
            double distance = this.sortMode.startDouble();
            double result = MISSING_VALUE;
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.readerValues.nextValue();
                result = distance = this.sortMode.apply(distance, this.fixedSourceDistance.calculate(point.lat(), point.lon()));
            }
            return this.sortMode.reduce(result, length);
        }
    }

    private static final class SV
    extends GeoDistanceValues {
        SV(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance) {
            super(readerValues, fixedSourceDistance);
        }

        @Override
        public double computeDistance(int doc) {
            int numValues = this.readerValues.setDocument(doc);
            double result = MISSING_VALUE;
            int i = 0;
            if (i < numValues) {
                GeoPoint geoPoint = this.readerValues.nextValue();
                return this.fixedSourceDistance.calculate(geoPoint.lat(), geoPoint.lon());
            }
            return MISSING_VALUE;
        }
    }

    private static abstract class GeoDistanceValues {
        protected final GeoPointValues readerValues;
        protected final GeoDistance.FixedSourceDistance fixedSourceDistance;

        protected GeoDistanceValues(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance) {
            this.readerValues = readerValues;
            this.fixedSourceDistance = fixedSourceDistance;
        }

        public abstract double computeDistance(int var1);
    }
}

