/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.LongsRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public enum EmptyOrdinals implements Ordinals
{
    INSTANCE;


    @Override
    public long getMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public long getMaxOrd() {
        return 1L;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this);
    }

    public static class Docs
    extends Ordinals.AbstractDocs {
        public static final LongsRef EMPTY_LONGS_REF = new LongsRef();

        public Docs(EmptyOrdinals parent) {
            super(parent);
        }

        @Override
        public long getOrd(int docId) {
            return -1L;
        }

        @Override
        public long nextOrd() {
            throw new ElasticsearchIllegalStateException("Empty ordinals has no nextOrd");
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public long currentOrd() {
            return -1L;
        }
    }
}

