/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.FloatArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class FloatArrayIndexFieldData
extends AbstractIndexFieldData<FloatArrayAtomicFieldData>
implements IndexNumericFieldData<FloatArrayAtomicFieldData> {
    private final CircuitBreakerService breakerService;

    public FloatArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.FLOAT;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public FloatArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        FloatArrayAtomicFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = FloatArrayAtomicFieldData.empty();
            estimator.afterLoad(null, data.getMemorySizeInBytes());
            return data;
        }
        FloatArray values = BigArrays.NON_RECYCLING_INSTANCE.newFloatArray(128L);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            FloatArrayAtomicFieldData floatArrayAtomicFieldData;
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), acceptableTransientOverheadRatio);){
                BytesRef term;
                BytesRefIterator iter = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator(null)));
                long numTerms = 0L;
                while ((term = iter.next()) != null) {
                    values = BigArrays.NON_RECYCLING_INSTANCE.grow(values, numTerms + 1L);
                    values.set(numTerms++, NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)term)));
                }
                values = BigArrays.NON_RECYCLING_INSTANCE.resize(values, numTerms);
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                if (build.isMultiValued() || IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    data = new FloatArrayAtomicFieldData.WithOrdinals(values, build);
                } else {
                    long ordinalsSize;
                    Ordinals.Docs ordinals = build.ordinals();
                    FixedBitSet set = builder.buildDocsWithValuesSet();
                    long singleValuesArraySize = (long)(reader.maxDoc() * 4) + (set == null ? 0L : RamUsageEstimator.sizeOf((long[])set.getBits()) + 4L);
                    long uniqueValuesArraySize = values.sizeInBytes();
                    if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                        data = new FloatArrayAtomicFieldData.WithOrdinals(values, build);
                        success = true;
                        FloatArrayAtomicFieldData floatArrayAtomicFieldData2 = data;
                        return floatArrayAtomicFieldData2;
                    }
                    int maxDoc = reader.maxDoc();
                    FloatArray sValues = BigArrays.NON_RECYCLING_INSTANCE.newFloatArray(maxDoc);
                    for (int i = 0; i < maxDoc; ++i) {
                        long ordinal = ordinals.getOrd(i);
                        if (ordinal == -1L) continue;
                        sValues.set(i, values.get(ordinal));
                    }
                    assert (sValues.size() == (long)maxDoc);
                    data = set == null ? new FloatArrayAtomicFieldData.Single(sValues, ordinals.getMaxOrd() - 0L) : new FloatArrayAtomicFieldData.SingleFixedSet(sValues, set, ordinals.getMaxOrd() - 0L);
                }
                success = true;
                floatArrayAtomicFieldData = data;
            }
            return floatArrayAtomicFieldData;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.getMemorySizeInBytes());
            }
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode) {
        return new FloatValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            return new FloatArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

