/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

final class GeoPointBinaryDVAtomicFieldData
extends AtomicGeoPointFieldData<ScriptDocValues> {
    private final BinaryDocValues values;

    GeoPointBinaryDVAtomicFieldData(BinaryDocValues values) {
        this.values = values == null ? DocValues.EMPTY_BINARY : values;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public long getNumberUniqueValues() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMemorySizeInBytes() {
        return -1L;
    }

    @Override
    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.GeoPoints(this.getGeoPointValues());
    }

    @Override
    public void close() {
    }

    @Override
    public GeoPointValues getGeoPointValues() {
        return new GeoPointValues(true){
            final BytesRef bytes;
            int i;
            int valueCount;
            final GeoPoint point;
            {
                this.bytes = new BytesRef();
                this.i = Integer.MAX_VALUE;
                this.valueCount = 0;
                this.point = new GeoPoint();
            }

            @Override
            public int setDocument(int docId) {
                GeoPointBinaryDVAtomicFieldData.this.values.get(docId, this.bytes);
                assert (this.bytes.length % 16 == 0);
                this.i = 0;
                this.valueCount = this.bytes.length >>> 4;
                return this.valueCount;
            }

            @Override
            public GeoPoint nextValue() {
                assert (this.i < 2 * this.valueCount);
                double lat = ByteUtils.readDoubleLE(this.bytes.bytes, this.bytes.offset + this.i++ * 8);
                double lon = ByteUtils.readDoubleLE(this.bytes.bytes, this.bytes.offset + this.i++ * 8);
                return this.point.reset(lat, lon);
            }
        };
    }
}

