/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.EmptyOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AtomicFieldDataWithOrdinalsTermsEnum;
import org.elasticsearch.index.fielddata.plain.EmptyByteValuesWithOrdinals;

public class PagedBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    private final PagedBytes.Reader bytes;
    private final MonotonicAppendingLongBuffer termOrdToBytesOffset;
    protected final Ordinals ordinals;
    private volatile IntArray hashes;
    private long size = -1L;
    private final long readerBytesSize;

    public static PagedBytesAtomicFieldData empty() {
        return new Empty();
    }

    public PagedBytesAtomicFieldData(PagedBytes.Reader bytes, long readerBytesSize, MonotonicAppendingLongBuffer termOrdToBytesOffset, Ordinals ordinals) {
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
        this.readerBytesSize = readerBytesSize;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isMultiValued() {
        return this.ordinals.isMultiValued();
    }

    @Override
    public long getNumberUniqueValues() {
        return this.ordinals.getMaxOrd() - 0L;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            long size = this.ordinals.getMemorySizeInBytes();
            size += this.readerBytesSize;
            this.size = size += this.termOrdToBytesOffset.ramBytesUsed();
        }
        return this.size;
    }

    private final IntArray getHashes() {
        if (this.hashes == null) {
            long numberOfValues = this.termOrdToBytesOffset.size();
            IntArray hashes = BigArrays.NON_RECYCLING_INSTANCE.newIntArray(numberOfValues);
            BytesRef scratch = new BytesRef();
            for (long i = 0L; i < numberOfValues; ++i) {
                this.bytes.fill(scratch, this.termOrdToBytesOffset.get(i));
                hashes.set(i, scratch.hashCode());
            }
            this.hashes = hashes;
        }
        return this.hashes;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
        if (needsHashes) {
            IntArray hashes = this.getHashes();
            return new BytesValues.HashedBytesValues(hashes, this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals());
        }
        return new BytesValues(this.bytes, this.termOrdToBytesOffset, this.ordinals.ordinals());
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues(false));
    }

    @Override
    public TermsEnum getTermsEnum() {
        return new AtomicFieldDataWithOrdinalsTermsEnum(this);
    }

    private static final class Empty
    extends PagedBytesAtomicFieldData {
        Empty() {
            super(Empty.emptyBytes(), 0L, new MonotonicAppendingLongBuffer(), EmptyOrdinals.INSTANCE);
        }

        static PagedBytes.Reader emptyBytes() {
            PagedBytes bytes = new PagedBytes(1);
            bytes.copyUsingLengthPrefix(new BytesRef());
            return bytes.freeze(true);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return 0L;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
            return new EmptyByteValuesWithOrdinals(this.ordinals.ordinals());
        }

        @Override
        public ScriptDocValues.Strings getScriptValues() {
            return ScriptDocValues.EMPTY_STRINGS;
        }
    }

    static class BytesValues
    extends BytesValues.WithOrdinals {
        protected final PagedBytes.Reader bytes;
        protected final MonotonicAppendingLongBuffer termOrdToBytesOffset;
        protected final Ordinals.Docs ordinals;

        BytesValues(PagedBytes.Reader bytes, MonotonicAppendingLongBuffer termOrdToBytesOffset, Ordinals.Docs ordinals) {
            super(ordinals);
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.ordinals = ordinals;
        }

        @Override
        public BytesRef copyShared() {
            return new BytesRef(this.scratch.bytes, this.scratch.offset, this.scratch.length);
        }

        @Override
        public final Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        @Override
        public final BytesRef getValueByOrd(long ord) {
            assert (ord != -1L);
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
            return this.scratch;
        }

        @Override
        public final BytesRef nextValue() {
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(this.ordinals.nextOrd()));
            return this.scratch;
        }

        static final class HashedBytesValues
        extends BytesValues {
            private final IntArray hashes;

            HashedBytesValues(IntArray hashes, PagedBytes.Reader bytes, MonotonicAppendingLongBuffer termOrdToBytesOffset, Ordinals.Docs ordinals) {
                super(bytes, termOrdToBytesOffset, ordinals);
                this.hashes = hashes;
            }

            @Override
            public int currentValueHash() {
                assert (this.ordinals.currentOrd() >= 0L);
                return this.hashes.get(this.ordinals.currentOrd());
            }
        }
    }
}

