/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersLookup;

public class DocumentFieldMappers
implements Iterable<FieldMapper> {
    private final DocumentMapper docMapper;
    private final FieldMappersLookup fieldMappers;
    private volatile FieldNameAnalyzer indexAnalyzer;
    private volatile FieldNameAnalyzer searchAnalyzer;
    private volatile FieldNameAnalyzer searchQuoteAnalyzer;

    public DocumentFieldMappers(DocumentMapper docMapper) {
        this.docMapper = docMapper;
        this.fieldMappers = new FieldMappersLookup();
        this.indexAnalyzer = new FieldNameAnalyzer(ImmutableOpenMap.of(), docMapper.indexAnalyzer());
        this.searchAnalyzer = new FieldNameAnalyzer(ImmutableOpenMap.of(), docMapper.searchAnalyzer());
        this.searchQuoteAnalyzer = new FieldNameAnalyzer(ImmutableOpenMap.of(), docMapper.searchQuotedAnalyzer());
    }

    public void addNewMappers(Iterable<FieldMapper> newMappers) {
        this.fieldMappers.addNewMappers(newMappers);
        ImmutableOpenMap.Builder<String, Analyzer> indexAnalyzers = ImmutableOpenMap.builder(this.indexAnalyzer.analyzers());
        ImmutableOpenMap.Builder<String, Analyzer> searchAnalyzers = ImmutableOpenMap.builder(this.searchAnalyzer.analyzers());
        ImmutableOpenMap.Builder<String, Analyzer> searchQuoteAnalyzers = ImmutableOpenMap.builder(this.searchQuoteAnalyzer.analyzers());
        for (FieldMapper fieldMapper : newMappers) {
            if (fieldMapper.indexAnalyzer() != null) {
                indexAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.indexAnalyzer());
            }
            if (fieldMapper.searchAnalyzer() != null) {
                searchAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.searchAnalyzer());
            }
            if (fieldMapper.searchQuoteAnalyzer() == null) continue;
            searchQuoteAnalyzers.put(fieldMapper.names().indexName(), fieldMapper.searchQuoteAnalyzer());
        }
        this.indexAnalyzer = new FieldNameAnalyzer(indexAnalyzers.build(), this.docMapper.indexAnalyzer());
        this.searchAnalyzer = new FieldNameAnalyzer(searchAnalyzers.build(), this.docMapper.searchAnalyzer());
        this.searchQuoteAnalyzer = new FieldNameAnalyzer(searchQuoteAnalyzers.build(), this.docMapper.searchQuotedAnalyzer());
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return this.fieldMappers.iterator();
    }

    public ImmutableList<FieldMapper> mappers() {
        return this.fieldMappers.mappers();
    }

    public boolean hasMapper(FieldMapper fieldMapper) {
        return this.fieldMappers.mappers().contains(fieldMapper);
    }

    public FieldMappers name(String name) {
        return this.fieldMappers.name(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.fieldMappers.indexName(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fieldMappers.fullName(fullName);
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        return this.fieldMappers.simpleMatchToIndexNames(pattern);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.fieldMappers.simpleMatchToFullName(pattern);
    }

    public FieldMappers smartName(String name) {
        return this.fieldMappers.smartName(name);
    }

    public FieldMapper smartNameFieldMapper(String name) {
        return this.fieldMappers.smartNameFieldMapper(name);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer indexAnalyzer(Analyzer defaultAnalyzer) {
        return new FieldNameAnalyzer(this.indexAnalyzer.analyzers(), defaultAnalyzer);
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }
}

