/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.all.AllField;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class AllFieldMapper
extends AbstractFieldMapper<Void>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    private boolean enabled;
    private volatile boolean autoBoost;

    public AllFieldMapper() {
        this("_all", new FieldType(Defaults.FIELD_TYPE), null, null, true, false, null, null, null, null, null, ImmutableSettings.EMPTY);
    }

    protected AllFieldMapper(String name, FieldType fieldType, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, boolean enabled, boolean autoBoost, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, name, name, name), 1.0f, fieldType, null, indexAnalyzer, searchAnalyzer, postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings);
        this.enabled = enabled;
        this.autoBoost = autoBoost;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("string");
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        if (!this.autoBoost) {
            return new TermQuery(term);
        }
        if (this.fieldType.indexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            return new AllTermQuery(term);
        }
        return new TermQuery(term);
    }

    @Override
    public Query termQuery(Object value, QueryParseContext context) {
        return this.queryStringTermQuery(this.names().createIndexNameTerm(this.indexedValueForSearch(value)));
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.enabled) {
            return;
        }
        context.allEntries().reset();
        if (!this.autoBoost && context.allEntries().customBoost()) {
            this.autoBoost = true;
            context.setMappingsModified();
        }
        Analyzer analyzer = this.findAnalyzer(context);
        fields.add(new AllField(this.names.indexName(), context.allEntries(), analyzer, this.fieldType));
    }

    private Analyzer findAnalyzer(ParseContext context) {
        NamedAnalyzer analyzer = this.indexAnalyzer;
        if (analyzer == null && (analyzer = context.analyzer()) == null && (analyzer = context.docMapper().indexAnalyzer()) == null) {
            analyzer = Lucene.STANDARD_ANALYZER;
        }
        return analyzer;
    }

    @Override
    public Void value(Object value) {
        return null;
    }

    @Override
    public Object valueForSearch(Object value) {
        return null;
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults) {
            BytesStreamOutput bytesStreamOutput = new BytesStreamOutput(0);
            XContentBuilder b = new XContentBuilder(builder.contentType().xContent(), bytesStreamOutput);
            long pos = bytesStreamOutput.position();
            this.innerToXContent(b, false);
            b.flush();
            if (pos == bytesStreamOutput.position()) {
                return builder;
            }
        }
        builder.startObject("_all");
        this.innerToXContent(builder, includeDefaults);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || !this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (includeDefaults || this.autoBoost) {
            builder.field("auto_boost", this.autoBoost);
        }
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.fieldType.storeTermVectors() != Defaults.FIELD_TYPE.storeTermVectors()) {
            builder.field("store_term_vectors", this.fieldType.storeTermVectors());
        }
        if (includeDefaults || this.fieldType.storeTermVectorOffsets() != Defaults.FIELD_TYPE.storeTermVectorOffsets()) {
            builder.field("store_term_vector_offsets", this.fieldType.storeTermVectorOffsets());
        }
        if (includeDefaults || this.fieldType.storeTermVectorPositions() != Defaults.FIELD_TYPE.storeTermVectorPositions()) {
            builder.field("store_term_vector_positions", this.fieldType.storeTermVectorPositions());
        }
        if (includeDefaults || this.fieldType.storeTermVectorPayloads() != Defaults.FIELD_TYPE.storeTermVectorPayloads()) {
            builder.field("store_term_vector_payloads", this.fieldType.storeTermVectorPayloads());
        }
        if (includeDefaults || this.fieldType.omitNorms() != Defaults.FIELD_TYPE.omitNorms()) {
            builder.field("omit_norms", this.fieldType.omitNorms());
        }
        if (this.indexAnalyzer == null && this.searchAnalyzer == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else if (this.indexAnalyzer == null) {
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        } else if (this.searchAnalyzer == null) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
        } else if (this.indexAnalyzer.name().equals(this.searchAnalyzer.name())) {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("analyzer", this.indexAnalyzer.name());
            }
        } else {
            if (includeDefaults || !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (includeDefaults || !this.searchAnalyzer.name().startsWith("_")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
        if (this.similarity() != null) {
            builder.field("similarity", this.similarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "default");
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.all();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("auto_boost")) continue;
                builder.autoBoost = XContentMapValues.nodeBooleanValue(fieldNode);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, AllFieldMapper> {
        private boolean enabled = true;
        boolean autoBoost = false;

        public Builder() {
            super("_all", new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
            this.indexName = "_all";
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setIndexed(true);
            this.fieldType.setTokenized(true);
            return new AllFieldMapper(this.name, this.fieldType, this.indexAnalyzer, this.searchAnalyzer, this.enabled, this.autoBoost, this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_all";
        public static final String INDEX_NAME = "_all";
        public static final boolean ENABLED = true;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.freeze();
        }
    }

    public static interface IncludeInAll
    extends Mapper {
        public void includeInAll(Boolean var1);

        public void includeInAllIfNotSet(Boolean var1);

        public void unsetIncludeInAll();
    }
}

