/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.XStringField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class ParentFieldMapper
extends AbstractFieldMapper<Uid>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_parent";
    public static final String CONTENT_TYPE = "_parent";
    private final String type;
    private final BytesRef typeAsBytes;

    protected ParentFieldMapper(String name, String indexName, String type, PostingsFormatProvider postingsFormat, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), 1.0f, new FieldType(Defaults.FIELD_TYPE), null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsFormat, null, null, null, fieldDataSettings, indexSettings);
        this.type = type;
        this.typeAsBytes = type == null ? null : new BytesRef((CharSequence)type);
    }

    public ParentFieldMapper() {
        this("_parent", "_parent", null, null, null, null);
    }

    public String type() {
        return this.type;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("_parent");
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        this.parse(context);
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.active()) {
            return;
        }
        if (context.parser().currentName() != null && context.parser().currentName().equals("_parent")) {
            String parentId = context.parser().text();
            context.sourceToParse().parent(parentId);
            fields.add(new XStringField(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.fieldType));
        } else {
            String parsedParentId = context.doc().get("_parent");
            if (context.sourceToParse().parent() != null) {
                String parentId = context.sourceToParse().parent();
                if (parsedParentId == null) {
                    if (parentId == null) {
                        throw new MapperParsingException("No parent id provided, not within the document, and not externally");
                    }
                    fields.add(new XStringField(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.fieldType));
                } else if (parentId != null && !parsedParentId.equals(Uid.createUid(context.stringBuilder(), this.type, parentId))) {
                    throw new MapperParsingException("Parent id mismatch, document value is [" + Uid.createUid(parsedParentId).id() + "], while external value is [" + parentId + "]");
                }
            }
        }
    }

    @Override
    public Uid value(Object value) {
        if (value == null) {
            return null;
        }
        return Uid.createUid(value.toString());
    }

    @Override
    public Object valueForSearch(Object value) {
        if (value == null) {
            return null;
        }
        String sValue = value.toString();
        if (sValue == null) {
            return null;
        }
        int index = sValue.indexOf(35);
        if (index == -1) {
            return sValue;
        }
        return sValue.substring(index + 1);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        if (value instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)value;
            if (Uid.hasDelimiter(bytesRef)) {
                return bytesRef;
            }
            return Uid.createUidAsBytes(this.typeAsBytes, bytesRef);
        }
        String sValue = value.toString();
        if (sValue.indexOf(35) == -1) {
            return Uid.createUidAsBytes(this.type, sValue);
        }
        return super.indexedValueForSearch(value);
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        if (context == null) {
            return super.termQuery(value, context);
        }
        return new ConstantScoreQuery(this.termFilter(value, context));
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        if (context == null) {
            return super.termFilter(value, context);
        }
        BytesRef bValue = BytesRefs.toBytesRef(value);
        if (Uid.hasDelimiter(bValue)) {
            return new TermFilter(new Term(this.names.indexName(), bValue));
        }
        ArrayList<String> types = new ArrayList<String>(context.mapperService().types().size());
        for (DocumentMapper documentMapper : context.mapperService()) {
            if (documentMapper.parentFieldMapper().active()) continue;
            types.add(documentMapper.type());
        }
        if (types.isEmpty()) {
            return Queries.MATCH_NO_FILTER;
        }
        if (types.size() == 1) {
            return new TermFilter(new Term(this.names.indexName(), Uid.createUidAsBytes((String)types.get(0), bValue)));
        }
        ArrayList<BytesRef> typesValues = new ArrayList<BytesRef>(types.size());
        for (String type : context.mapperService().types()) {
            typesValues.add(Uid.createUidAsBytes(type, bValue));
        }
        return new TermsFilter(this.names.indexName(), typesValues);
    }

    @Override
    public Filter termsFilter(List values, @Nullable QueryParseContext context) {
        if (context == null) {
            return super.termsFilter(values, context);
        }
        if (values.size() == 1) {
            return this.termFilter(values.get(0), context);
        }
        ArrayList<String> types = new ArrayList<String>(context.mapperService().types().size());
        for (DocumentMapper documentMapper : context.mapperService()) {
            if (documentMapper.parentFieldMapper().active()) continue;
            types.add(documentMapper.type());
        }
        ArrayList<BytesRef> bValues = new ArrayList<BytesRef>(values.size());
        for (Object value : values) {
            BytesRef bValue = BytesRefs.toBytesRef(value);
            if (Uid.hasDelimiter(bValue)) {
                bValues.add(bValue);
                continue;
            }
            for (String type : types) {
                bValues.add(Uid.createUidAsBytes(type, bValue));
            }
        }
        return new TermsFilter(this.names.indexName(), bValues);
    }

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    protected String contentType() {
        return "_parent";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.active()) {
            return builder;
        }
        builder.startObject("_parent");
        builder.field("type", this.type);
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        ParentFieldMapper other = (ParentFieldMapper)mergeWith;
        if (this.active() == other.active()) {
            return;
        }
        if (this.active() != other.active() || !this.type.equals(other.type)) {
            mergeContext.addConflict("The _parent field can't be added or updated");
        }
    }

    public boolean active() {
        return this.type != null;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.parent();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) {
                    builder.type(fieldNode.toString());
                    continue;
                }
                if (!fieldName.equals("postings_format")) continue;
                String postingFormatName = fieldNode.toString();
                builder.postingsFormat(parserContext.postingFormatService().get(postingFormatName));
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, ParentFieldMapper> {
        private static final Settings FIELD_DATA_SETTINGS = ImmutableSettings.settingsBuilder().put("loading", "eager").build();
        protected String indexName;
        private String type;
        protected PostingsFormatProvider postingsFormat;

        public Builder() {
            super("_parent");
            this.indexName = this.name;
            this.builder = this;
        }

        public Builder type(String type) {
            this.type = type;
            return (Builder)this.builder;
        }

        protected Builder postingsFormat(PostingsFormatProvider postingsFormat) {
            this.postingsFormat = postingsFormat;
            return (Builder)this.builder;
        }

        @Override
        public ParentFieldMapper build(Mapper.BuilderContext context) {
            if (this.type == null) {
                throw new MapperParsingException("Parent mapping must contain the parent type");
            }
            return new ParentFieldMapper(this.name, this.indexName, this.type, this.postingsFormat, FIELD_DATA_SETTINGS, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_parent";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }
}

