/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;

public class TemplateQueryParser
implements QueryParser {
    public static final String NAME = "template";
    public static final String QUERY = "query";
    public static final String PARAMS = "params";
    private final ScriptService scriptService;

    @Inject
    public TemplateQueryParser(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    @Nullable
    public Query parse(QueryParseContext parseContext) throws IOException {
        XContentParser parser = parseContext.parser();
        TemplateContext templateContext = TemplateQueryParser.parse(parser, QUERY, PARAMS);
        ExecutableScript executable = this.scriptService.executable("mustache", templateContext.template(), templateContext.params());
        BytesReference querySource = (BytesReference)executable.run();
        try (XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);){
            Query result;
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParser);
            context.reset(qSourceParser);
            Query query = result = context.parseInnerQuery();
            return query;
        }
    }

    public static TemplateContext parse(XContentParser parser, String templateFieldname, String paramsFieldname) throws IOException {
        XContentParser.Token token;
        Map<String, Object> params = null;
        String templateNameOrTemplateContent = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (templateFieldname.equals(currentFieldName)) {
                if (token == XContentParser.Token.START_OBJECT && !parser.hasTextCharacters()) {
                    XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
                    builder.copyCurrentStructure(parser);
                    templateNameOrTemplateContent = builder.string();
                    continue;
                }
                templateNameOrTemplateContent = parser.text();
                continue;
            }
            if (!paramsFieldname.equals(currentFieldName)) continue;
            params = parser.map();
        }
        return new TemplateContext(templateNameOrTemplateContent, params);
    }

    public static class TemplateContext {
        private Map<String, Object> params;
        private String template;

        public TemplateContext(String templateName, Map<String, Object> params) {
            this.params = params;
            this.template = templateName;
        }

        public Map<String, Object> params() {
            return this.params;
        }

        public String template() {
            return this.template;
        }
    }
}

