/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.internal.SearchContext;

public abstract class DecayFunctionParser
implements ScoreFunctionParser {
    public static final ParseField MULTI_VALUE_MODE = new ParseField("multi_value_mode", new String[0]);

    public abstract DecayFunction getDecayFunction();

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        AbstractDistanceScoreFunction scoreFunction = null;
        String multiValueMode = "MIN";
        XContentBuilder variableContent = XContentFactory.jsonBuilder();
        String fieldName = null;
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                variableContent.copyCurrentStructure(parser);
                fieldName = currentFieldName;
                continue;
            }
            if (MULTI_VALUE_MODE.match(currentFieldName)) {
                multiValueMode = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("Malformed score function score parameters.");
        }
        if (fieldName == null) {
            throw new ElasticsearchParseException("Malformed score function score parameters.");
        }
        XContentParser variableParser = XContentFactory.xContent(variableContent.string()).createParser(variableContent.string());
        scoreFunction = this.parseVariable(fieldName, variableParser, parseContext, MultiValueMode.fromString(multiValueMode.toUpperCase(Locale.ROOT)));
        return scoreFunction;
    }

    private AbstractDistanceScoreFunction parseVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, MultiValueMode mode) throws IOException {
        MapperService.SmartNameFieldMappers smartMappers = parseContext.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "Unknown field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.fieldMappers().mapper();
        parser.nextToken();
        if (mapper instanceof DateFieldMapper) {
            return this.parseDateVariable(fieldName, parser, parseContext, (DateFieldMapper)mapper, mode);
        }
        if (mapper instanceof GeoPointFieldMapper) {
            return this.parseGeoVariable(fieldName, parser, parseContext, (GeoPointFieldMapper)mapper, mode);
        }
        if (mapper instanceof NumberFieldMapper) {
            return this.parseNumberVariable(fieldName, parser, parseContext, (NumberFieldMapper)mapper, mode);
        }
        throw new QueryParsingException(parseContext.index(), "Field " + fieldName + " is of type " + mapper.fieldType() + ", but only numeric types are supported.");
    }

    private AbstractDistanceScoreFunction parseNumberVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, NumberFieldMapper<?> mapper, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        double scale = 0.0;
        double origin = 0.0;
        double decay = 0.5;
        double offset = 0.0;
        boolean scaleFound = false;
        boolean refFound = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scale = parser.doubleValue();
                scaleFound = true;
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = parser.doubleValue();
                refFound = true;
                continue;
            }
            if (parameterName.equals("offset")) {
                offset = parser.doubleValue();
                continue;
            }
            throw new ElasticsearchParseException("Parameter " + parameterName + " not supported!");
        }
        if (!scaleFound || !refFound) {
            throw new ElasticsearchParseException("Both scaleand origin must be set for numeric fields.");
        }
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.fieldData().getForField(mapper);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode);
    }

    private AbstractDistanceScoreFunction parseGeoVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, GeoPointFieldMapper mapper, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        GeoPoint origin = new GeoPoint();
        String scaleString = null;
        String offsetString = "0km";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = GeoUtils.parseGeoPoint(parser);
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("Parameter " + parameterName + " not supported!");
        }
        if (origin == null || scaleString == null) {
            throw new ElasticsearchParseException("origin and scale must be set for geo fields.");
        }
        double scale = DistanceUnit.DEFAULT.parse(scaleString, DistanceUnit.DEFAULT);
        double offset = DistanceUnit.DEFAULT.parse(offsetString, DistanceUnit.DEFAULT);
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.fieldData().getForField(mapper);
        return new GeoFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), indexFieldData, mode);
    }

    private AbstractDistanceScoreFunction parseDateVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, DateFieldMapper dateFieldMapper, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        String scaleString = null;
        String originString = null;
        String offsetString = "0d";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                originString = parser.text();
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("Parameter " + parameterName + " not supported!");
        }
        long origin = SearchContext.current().nowInMillis();
        if (originString != null) {
            origin = dateFieldMapper.parseToMilliseconds(originString, parseContext);
        }
        if (scaleString == null) {
            throw new ElasticsearchParseException("scale must be set for date fields.");
        }
        TimeValue val = TimeValue.parseTimeValue(scaleString, TimeValue.timeValueHours(24L));
        double scale = val.getMillis();
        val = TimeValue.parseTimeValue(offsetString, TimeValue.timeValueHours(24L));
        double offset = val.getMillis();
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.fieldData().getForField(dateFieldMapper);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode);
    }

    public static abstract class AbstractDistanceScoreFunction
    extends ScoreFunction {
        private final double scale;
        protected final double offset;
        private final DecayFunction func;
        protected final MultiValueMode mode;

        public AbstractDistanceScoreFunction(double userSuppiedScale, double decay, double offset, DecayFunction func, MultiValueMode mode) {
            super(CombineFunction.MULT);
            this.mode = mode;
            if (userSuppiedScale <= 0.0) {
                throw new ElasticsearchIllegalArgumentException("function_score : scale must be > 0.0.");
            }
            if (decay <= 0.0 || decay >= 1.0) {
                throw new ElasticsearchIllegalArgumentException("function_score : decay must be in the range [0..1].");
            }
            this.scale = func.processScale(userSuppiedScale, decay);
            this.func = func;
            if (offset < 0.0) {
                throw new ElasticsearchIllegalArgumentException("function_score : offset must be > 0.0");
            }
            this.offset = offset;
        }

        @Override
        public double score(int docId, float subQueryScore) {
            double value = this.distance(docId);
            return this.func.evaluate(value, this.scale);
        }

        protected abstract double distance(int var1);

        protected abstract String getDistanceString(int var1);

        protected abstract String getFieldName();

        @Override
        public Explanation explainScore(int docId, Explanation subQueryExpl) {
            ComplexExplanation ce = new ComplexExplanation();
            ce.setValue(CombineFunction.toFloat(this.score(docId, subQueryExpl.getValue())));
            ce.setMatch(Boolean.valueOf(true));
            ce.setDescription("Function for field " + this.getFieldName() + ":");
            ce.addDetail(this.func.explainFunction(this.getDistanceString(docId), this.distance(docId), this.scale));
            return ce;
        }
    }

    static class NumericFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final IndexNumericFieldData<?> fieldData;
        private final double origin;
        private DoubleValues doubleValues;

        public NumericFieldDataScoreFunction(double origin, double scale, double decay, double offset, DecayFunction func, IndexNumericFieldData<?> fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.fieldData = fieldData;
            this.origin = origin;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
            this.doubleValues = this.fieldData.load(context).getDoubleValues();
        }

        @Override
        protected double distance(int docId) {
            int num = this.doubleValues.setDocument(docId);
            if (num > 0) {
                double value = this.mode.startDouble();
                for (int i = 0; i < num; ++i) {
                    double other = this.doubleValues.nextValue();
                    value = this.mode.apply(Math.max(0.0, Math.abs(other - this.origin) - this.offset), value);
                }
                return this.mode.reduce(value, num);
            }
            return 0.0;
        }

        @Override
        protected String getDistanceString(int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append(" of: [");
            int num = this.doubleValues.setDocument(docId);
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    double value = this.doubleValues.nextValue();
                    values.append("Math.max(Math.abs(");
                    values.append(value).append("(=doc value) - ").append(this.origin).append("(=origin))) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }

    static class GeoFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final GeoPoint origin;
        private final IndexGeoPointFieldData<?> fieldData;
        private GeoPointValues geoPointValues = null;
        private static final GeoDistance distFunction = GeoDistance.DEFAULT;

        public GeoFieldDataScoreFunction(GeoPoint origin, double scale, double decay, double offset, DecayFunction func, IndexGeoPointFieldData<?> fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.origin = origin;
            this.fieldData = fieldData;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
            this.geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(context)).getGeoPointValues();
        }

        @Override
        protected double distance(int docId) {
            int num = this.geoPointValues.setDocument(docId);
            if (num > 0) {
                double value = this.mode.startDouble();
                for (int i = 0; i < num; ++i) {
                    GeoPoint other = this.geoPointValues.nextValue();
                    value = this.mode.apply(Math.max(0.0, distFunction.calculate(this.origin.lat(), this.origin.lon(), other.lat(), other.lon(), DistanceUnit.METERS) - this.offset), value);
                }
                return this.mode.reduce(value, num);
            }
            return 0.0;
        }

        @Override
        protected String getDistanceString(int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append(" of: [");
            int num = this.geoPointValues.setDocument(docId);
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    GeoPoint value = this.geoPointValues.nextValue();
                    values.append("Math.max(arcDistance(");
                    values.append(value).append("(=doc value),").append(this.origin).append("(=origin)) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }
}

