/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenConstantScoreQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalChildQuery;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenConstantScoreQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query childQuery, String parentType, String childType, Filter parentFilter, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentFilter = parentFilter;
        this.parentType = parentType;
        this.childType = childType;
        this.originalChildQuery = childQuery;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    public Query clone() {
        ChildrenConstantScoreQuery q = (ChildrenConstantScoreQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        SearchContext sc = SearchContext.current();
        IndexFieldData.WithOrdinals globalIfd = this.parentChildIndexFieldData.getGlobalParentChild(this.parentType, searcher.getIndexReader());
        assert (this.rewrittenChildQuery != null);
        assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
        List leaves = searcher.getIndexReader().leaves();
        if (globalIfd == null || leaves.isEmpty()) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        Object afd = globalIfd.load((AtomicReaderContext)leaves.get(0));
        BytesValues.WithOrdinals globalValues = afd.getBytesValues(false);
        Ordinals.Docs globalOrdinals = globalValues.ordinals();
        long maxOrd = globalOrdinals.getMaxOrd();
        if (maxOrd == 0L) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        Query childQuery = this.rewrittenChildQuery;
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        ParentOrdCollector collector = new ParentOrdCollector(globalIfd, maxOrd);
        indexSearcher.search(childQuery, (Collector)collector);
        long remaining = collector.foundParents();
        if (remaining == 0L) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        Filter shortCircuitFilter = null;
        if (remaining <= (long)this.shortCircuitParentDocSet) {
            shortCircuitFilter = ParentIdsFilter.createShortCircuitFilter(this.nonNestedDocsFilter, sc, this.parentType, collector.values, collector.parentOrds, remaining);
        }
        return new ParentWeight(this.parentFilter, globalIfd, shortCircuitFilter, collector, remaining);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenConstantScoreQuery that = (ChildrenConstantScoreQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        if (this.shortCircuitParentDocSet != that.shortCircuitParentDocSet) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + this.shortCircuitParentDocSet;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        return "child_filter[" + this.childType + "/" + this.parentType + "](" + this.originalChildQuery + ')';
    }

    private static final class ParentOrdIterator
    extends FilteredDocIdSetIterator {
        private final LongBitSet parentOrds;
        private final Ordinals.Docs ordinals;
        private final ParentWeight parentWeight;

        private ParentOrdIterator(DocIdSetIterator innerIterator, LongBitSet parentOrds, Ordinals.Docs ordinals, ParentWeight parentWeight) {
            super(innerIterator);
            this.parentOrds = parentOrds;
            this.ordinals = ordinals;
            this.parentWeight = parentWeight;
        }

        protected boolean match(int doc) {
            if (this.parentWeight.remaining == 0L) {
                try {
                    this.advance(Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
            long parentOrd = this.ordinals.getOrd(doc);
            if (parentOrd != -1L) {
                boolean match = this.parentOrds.get(parentOrd);
                if (match) {
                    this.parentWeight.remaining--;
                }
                return match;
            }
            return false;
        }
    }

    private static final class ParentOrdCollector
    extends NoopCollector {
        private final LongBitSet parentOrds;
        private final IndexFieldData.WithOrdinals indexFieldData;
        private BytesValues.WithOrdinals values;
        private Ordinals.Docs globalOrdinals;

        private ParentOrdCollector(IndexFieldData.WithOrdinals indexFieldData, long maxOrd) {
            this.parentOrds = new LongBitSet(maxOrd + 1L);
            this.indexFieldData = indexFieldData;
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.globalOrdinals != null && (globalOrdinal = this.globalOrdinals.getOrd(doc)) != -1L) {
                this.parentOrds.set(globalOrdinal);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = this.indexFieldData.load(context).getBytesValues(false);
            this.globalOrdinals = this.values != null ? this.values.ordinals() : null;
        }

        long foundParents() {
            return this.parentOrds.cardinality();
        }
    }

    private final class ParentWeight
    extends Weight {
        private final Filter parentFilter;
        private final Filter shortCircuitFilter;
        private final ParentOrdCollector collector;
        private final IndexFieldData.WithOrdinals globalIfd;
        private long remaining;
        private float queryNorm;
        private float queryWeight;

        public ParentWeight(Filter parentFilter, IndexFieldData.WithOrdinals globalIfd, Filter shortCircuitFilter, ParentOrdCollector collector, long remaining) {
            this.parentFilter = new ApplyAcceptedDocsFilter(parentFilter);
            this.globalIfd = globalIfd;
            this.shortCircuitFilter = shortCircuitFilter;
            this.collector = collector;
            this.remaining = remaining;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenConstantScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSetIterator innerIterator;
            if (this.remaining == 0L) {
                return null;
            }
            if (this.shortCircuitFilter != null) {
                DocIdSetIterator iterator;
                DocIdSet docIdSet = this.shortCircuitFilter.getDocIdSet(context, acceptDocs);
                if (!DocIdSets.isEmpty(docIdSet) && (iterator = docIdSet.iterator()) != null) {
                    return ConstantScorer.create(iterator, this, this.queryWeight);
                }
                return null;
            }
            DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (!DocIdSets.isEmpty(parentDocIdSet) && (innerIterator = (parentDocIdSet = BitsFilteredDocIdSet.wrap((DocIdSet)parentDocIdSet, (Bits)context.reader().getLiveDocs())).iterator()) != null) {
                LongBitSet parentOrds = this.collector.parentOrds;
                BytesValues.WithOrdinals globalValues = this.globalIfd.load(context).getBytesValues(false);
                if (globalValues != null) {
                    Ordinals.Docs globalOrdinals = globalValues.ordinals();
                    ParentOrdIterator parentIdIterator = new ParentOrdIterator(innerIterator, parentOrds, globalOrdinals, this);
                    return ConstantScorer.create((DocIdSetIterator)parentIdIterator, this, this.queryWeight);
                }
            }
            return null;
        }
    }
}

